/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.monitor.zeebe;

import io.zeebe.exporter.proto.Schema;
import io.zeebe.hazelcast.connect.java.ZeebeHazelcast;
import io.zeebe.monitor.entity.ElementInstanceEntity;
import io.zeebe.monitor.entity.IncidentEntity;
import io.zeebe.monitor.entity.JobEntity;
import io.zeebe.monitor.entity.MessageEntity;
import io.zeebe.monitor.entity.MessageSubscriptionEntity;
import io.zeebe.monitor.entity.TimerEntity;
import io.zeebe.monitor.entity.VariableEntity;
import io.zeebe.monitor.entity.WorkflowEntity;
import io.zeebe.monitor.entity.WorkflowInstanceEntity;
import io.zeebe.monitor.repository.ElementInstanceRepository;
import io.zeebe.monitor.repository.IncidentRepository;
import io.zeebe.monitor.repository.JobRepository;
import io.zeebe.monitor.repository.MessageRepository;
import io.zeebe.monitor.repository.MessageSubscriptionRepository;
import io.zeebe.monitor.repository.TimerRepository;
import io.zeebe.monitor.repository.VariableRepository;
import io.zeebe.monitor.repository.WorkflowInstanceRepository;
import io.zeebe.monitor.repository.WorkflowRepository;
import io.zeebe.monitor.zeebe.ZeebeNotificationService;
import io.zeebe.protocol.record.intent.DeploymentIntent;
import io.zeebe.protocol.record.intent.IncidentIntent;
import io.zeebe.protocol.record.intent.JobIntent;
import io.zeebe.protocol.record.intent.MessageIntent;
import io.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.zeebe.protocol.record.intent.TimerIntent;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ZeebeImportService {
    @Autowired
    private WorkflowRepository workflowRepository;
    @Autowired
    private WorkflowInstanceRepository workflowInstanceRepository;
    @Autowired
    private ElementInstanceRepository elementInstanceRepository;
    @Autowired
    private VariableRepository variableRepository;
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private IncidentRepository incidentRepository;
    @Autowired
    private MessageRepository messageRepository;
    @Autowired
    private MessageSubscriptionRepository messageSubscriptionRepository;
    @Autowired
    private TimerRepository timerRepository;
    @Autowired
    private ZeebeNotificationService notificationService;

    public void importFrom(ZeebeHazelcast zeebeHazelcast) {
        zeebeHazelcast.addDeploymentListener(arg_0 -> this.importDeployment(arg_0));
        zeebeHazelcast.addWorkflowInstanceListener(arg_0 -> this.importWorkflowInstance(arg_0));
        zeebeHazelcast.addIncidentListener(arg_0 -> this.importIncident(arg_0));
        zeebeHazelcast.addJobListener(arg_0 -> this.importJob(arg_0));
        zeebeHazelcast.addVariableListener(arg_0 -> this.importVariable(arg_0));
        zeebeHazelcast.addTimerListener(arg_0 -> this.importTimer(arg_0));
        zeebeHazelcast.addMessageListener(arg_0 -> this.importMessage(arg_0));
        zeebeHazelcast.addMessageSubscriptionListener(arg_0 -> this.importMessageSubscription(arg_0));
        zeebeHazelcast.addMessageStartEventSubscriptionListener(arg_0 -> this.importMessageStartEventSubscription(arg_0));
    }

    private void importDeployment(Schema.DeploymentRecord record) {
        DeploymentIntent intent = DeploymentIntent.valueOf((String)record.getMetadata().getIntent());
        int partitionId = record.getMetadata().getPartitionId();
        if (intent != DeploymentIntent.CREATED || partitionId != 1) {
            return;
        }
        record.getResourcesList().forEach(resource -> record.getDeployedWorkflowsList().stream().filter(w -> w.getResourceName().equals(resource.getResourceName())).forEach(deployedWorkflow -> {
            WorkflowEntity entity = new WorkflowEntity();
            entity.setKey(deployedWorkflow.getWorkflowKey());
            entity.setBpmnProcessId(deployedWorkflow.getBpmnProcessId());
            entity.setVersion(deployedWorkflow.getVersion());
            entity.setResource(resource.getResource().toStringUtf8());
            entity.setTimestamp(record.getMetadata().getTimestamp());
            this.workflowRepository.save((Object)entity);
        }));
    }

    private void importWorkflowInstance(Schema.WorkflowInstanceRecord record) {
        if (record.getWorkflowInstanceKey() == record.getMetadata().getKey()) {
            this.addOrUpdateWorkflowInstance(record);
        } else {
            this.addElementInstance(record);
        }
    }

    private void addOrUpdateWorkflowInstance(Schema.WorkflowInstanceRecord record) {
        WorkflowInstanceIntent intent = WorkflowInstanceIntent.valueOf((String)record.getMetadata().getIntent());
        long timestamp = record.getMetadata().getTimestamp();
        long workflowInstanceKey = record.getWorkflowInstanceKey();
        WorkflowInstanceEntity entity = this.workflowInstanceRepository.findById((Object)workflowInstanceKey).orElseGet(() -> {
            WorkflowInstanceEntity newEntity = new WorkflowInstanceEntity();
            newEntity.setPartitionId(record.getMetadata().getPartitionId());
            newEntity.setKey(workflowInstanceKey);
            newEntity.setBpmnProcessId(record.getBpmnProcessId());
            newEntity.setVersion(record.getVersion());
            newEntity.setWorkflowKey(record.getWorkflowKey());
            newEntity.setParentWorkflowInstanceKey(Long.valueOf(record.getParentWorkflowInstanceKey()));
            newEntity.setParentElementInstanceKey(Long.valueOf(record.getParentElementInstanceKey()));
            return newEntity;
        });
        if (intent == WorkflowInstanceIntent.ELEMENT_ACTIVATED) {
            entity.setState("Active");
            entity.setStart(timestamp);
            this.workflowInstanceRepository.save((Object)entity);
            this.notificationService.sendCreatedWorkflowInstance(record.getWorkflowInstanceKey(), record.getWorkflowKey());
        } else if (intent == WorkflowInstanceIntent.ELEMENT_COMPLETED) {
            entity.setState("Completed");
            entity.setEnd(Long.valueOf(timestamp));
            this.workflowInstanceRepository.save((Object)entity);
            this.notificationService.sendEndedWorkflowInstance(record.getWorkflowInstanceKey(), record.getWorkflowKey());
        } else if (intent == WorkflowInstanceIntent.ELEMENT_TERMINATED) {
            entity.setState("Terminated");
            entity.setEnd(Long.valueOf(timestamp));
            this.workflowInstanceRepository.save((Object)entity);
            this.notificationService.sendEndedWorkflowInstance(record.getWorkflowInstanceKey(), record.getWorkflowKey());
        }
    }

    private void addElementInstance(Schema.WorkflowInstanceRecord record) {
        long position = record.getMetadata().getPosition();
        if (!this.elementInstanceRepository.existsById((Object)position)) {
            ElementInstanceEntity entity = new ElementInstanceEntity();
            entity.setPosition(Long.valueOf(position));
            entity.setPartitionId(record.getMetadata().getPartitionId());
            entity.setKey(record.getMetadata().getKey());
            entity.setIntent(record.getMetadata().getIntent());
            entity.setTimestamp(record.getMetadata().getTimestamp());
            entity.setWorkflowInstanceKey(record.getWorkflowInstanceKey());
            entity.setElementId(record.getElementId());
            entity.setFlowScopeKey(record.getFlowScopeKey());
            entity.setWorkflowKey(record.getWorkflowKey());
            entity.setBpmnElementType(record.getBpmnElementType().name());
            this.elementInstanceRepository.save((Object)entity);
            this.notificationService.sendWorkflowInstanceUpdated(record.getWorkflowInstanceKey(), record.getWorkflowKey());
        }
    }

    private void importIncident(Schema.IncidentRecord record) {
        IncidentIntent intent = IncidentIntent.valueOf((String)record.getMetadata().getIntent());
        long key = record.getMetadata().getKey();
        long timestamp = record.getMetadata().getTimestamp();
        IncidentEntity entity = this.incidentRepository.findById((Object)key).orElseGet(() -> {
            IncidentEntity newEntity = new IncidentEntity();
            newEntity.setKey(key);
            newEntity.setBpmnProcessId(record.getBpmnProcessId());
            newEntity.setWorkflowKey(record.getWorkflowKey());
            newEntity.setWorkflowInstanceKey(record.getWorkflowInstanceKey());
            newEntity.setElementInstanceKey(record.getElementInstanceKey());
            newEntity.setJobKey(record.getJobKey());
            newEntity.setErrorType(record.getErrorType());
            newEntity.setErrorMessage(record.getErrorMessage());
            return newEntity;
        });
        if (intent == IncidentIntent.CREATED) {
            entity.setCreated(timestamp);
            this.incidentRepository.save((Object)entity);
        } else if (intent == IncidentIntent.RESOLVED) {
            entity.setResolved(Long.valueOf(timestamp));
            this.incidentRepository.save((Object)entity);
        }
    }

    private void importJob(Schema.JobRecord record) {
        JobIntent intent = JobIntent.valueOf((String)record.getMetadata().getIntent());
        long key = record.getMetadata().getKey();
        long timestamp = record.getMetadata().getTimestamp();
        JobEntity entity = this.jobRepository.findById((Object)key).orElseGet(() -> {
            JobEntity newEntity = new JobEntity();
            newEntity.setKey(key);
            newEntity.setWorkflowInstanceKey(record.getWorkflowInstanceKey());
            newEntity.setElementInstanceKey(record.getElementInstanceKey());
            newEntity.setJobType(record.getType());
            return newEntity;
        });
        entity.setState(intent.name().toLowerCase());
        entity.setTimestamp(timestamp);
        entity.setWorker(record.getWorker());
        entity.setRetries(record.getRetries());
        this.jobRepository.save((Object)entity);
    }

    private void importMessage(Schema.MessageRecord record) {
        MessageIntent intent = MessageIntent.valueOf((String)record.getMetadata().getIntent());
        long key = record.getMetadata().getKey();
        long timestamp = record.getMetadata().getTimestamp();
        MessageEntity entity = this.messageRepository.findById((Object)key).orElseGet(() -> {
            MessageEntity newEntity = new MessageEntity();
            newEntity.setKey(key);
            newEntity.setName(record.getName());
            newEntity.setCorrelationKey(record.getCorrelationKey());
            newEntity.setMessageId(record.getMessageId());
            newEntity.setPayload(record.getVariables().toString());
            return newEntity;
        });
        entity.setState(intent.name().toLowerCase());
        entity.setTimestamp(timestamp);
        this.messageRepository.save((Object)entity);
    }

    private void importMessageSubscription(Schema.MessageSubscriptionRecord record) {
        MessageSubscriptionIntent intent = MessageSubscriptionIntent.valueOf((String)record.getMetadata().getIntent());
        long timestamp = record.getMetadata().getTimestamp();
        MessageSubscriptionEntity entity = this.messageSubscriptionRepository.findByElementInstanceKeyAndMessageName(record.getElementInstanceKey(), record.getMessageName()).orElseGet(() -> {
            MessageSubscriptionEntity newEntity = new MessageSubscriptionEntity();
            newEntity.setId(this.generateId());
            newEntity.setElementInstanceKey(Long.valueOf(record.getElementInstanceKey()));
            newEntity.setMessageName(record.getMessageName());
            newEntity.setCorrelationKey(record.getCorrelationKey());
            newEntity.setWorkflowInstanceKey(Long.valueOf(record.getWorkflowInstanceKey()));
            return newEntity;
        });
        entity.setState(intent.name().toLowerCase());
        entity.setTimestamp(timestamp);
        this.messageSubscriptionRepository.save((Object)entity);
    }

    private void importMessageStartEventSubscription(Schema.MessageStartEventSubscriptionRecord record) {
        MessageStartEventSubscriptionIntent intent = MessageStartEventSubscriptionIntent.valueOf((String)record.getMetadata().getIntent());
        long timestamp = record.getMetadata().getTimestamp();
        MessageSubscriptionEntity entity = this.messageSubscriptionRepository.findByWorkflowKeyAndMessageName(record.getWorkflowKey(), record.getMessageName()).orElseGet(() -> {
            MessageSubscriptionEntity newEntity = new MessageSubscriptionEntity();
            newEntity.setId(this.generateId());
            newEntity.setMessageName(record.getMessageName());
            newEntity.setWorkflowKey(Long.valueOf(record.getWorkflowKey()));
            newEntity.setTargetFlowNodeId(record.getStartEventId());
            return newEntity;
        });
        entity.setState(intent.name().toLowerCase());
        entity.setTimestamp(timestamp);
        this.messageSubscriptionRepository.save((Object)entity);
    }

    private void importTimer(Schema.TimerRecord record) {
        TimerIntent intent = TimerIntent.valueOf((String)record.getMetadata().getIntent());
        long key = record.getMetadata().getKey();
        long timestamp = record.getMetadata().getTimestamp();
        TimerEntity entity = this.timerRepository.findById((Object)key).orElseGet(() -> {
            TimerEntity newEntity = new TimerEntity();
            newEntity.setKey(key);
            newEntity.setWorkflowKey(record.getWorkflowKey());
            newEntity.setTargetFlowNodeId(record.getTargetFlowNodeId());
            newEntity.setDueDate(record.getDueDate());
            newEntity.setRepetitions(record.getRepetitions());
            if (record.getWorkflowInstanceKey() > 0L) {
                newEntity.setWorkflowInstanceKey(Long.valueOf(record.getWorkflowInstanceKey()));
                newEntity.setElementInstanceKey(Long.valueOf(record.getElementInstanceKey()));
            }
            return newEntity;
        });
        entity.setState(intent.name().toLowerCase());
        entity.setTimestamp(timestamp);
        this.timerRepository.save((Object)entity);
    }

    private void importVariable(Schema.VariableRecord record) {
        long position = record.getMetadata().getPosition();
        if (!this.variableRepository.existsById((Object)position)) {
            VariableEntity entity = new VariableEntity();
            entity.setPosition(Long.valueOf(position));
            entity.setTimestamp(record.getMetadata().getTimestamp());
            entity.setWorkflowInstanceKey(record.getWorkflowInstanceKey());
            entity.setName(record.getName());
            entity.setValue(record.getValue());
            entity.setScopeKey(record.getScopeKey());
            entity.setState(record.getMetadata().getIntent().toLowerCase());
            this.variableRepository.save((Object)entity);
        }
    }

    private String generateId() {
        return UUID.randomUUID().toString();
    }
}

