/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.monitor.zeebe;

import io.zeebe.monitor.rest.WorkflowInstanceNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Controller;

@Controller
public class ZeebeNotificationService {
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeNotificationService.class);
    @Autowired
    private SimpMessagingTemplate webSocket;

    public void sendWorkflowInstanceUpdated(long workflowInstanceKey, long workflowKey) {
        WorkflowInstanceNotification notification = new WorkflowInstanceNotification();
        notification.setWorkflowInstanceKey(workflowInstanceKey);
        notification.setWorkflowKey(workflowKey);
        notification.setType(WorkflowInstanceNotification.Type.UPDATED);
        this.sendNotification(notification);
    }

    public void sendCreatedWorkflowInstance(long workflowInstanceKey, long workflowKey) {
        WorkflowInstanceNotification notification = new WorkflowInstanceNotification();
        notification.setWorkflowInstanceKey(workflowInstanceKey);
        notification.setWorkflowKey(workflowKey);
        notification.setType(WorkflowInstanceNotification.Type.CREATED);
        this.sendNotification(notification);
    }

    public void sendEndedWorkflowInstance(long workflowInstanceKey, long workflowKey) {
        WorkflowInstanceNotification notification = new WorkflowInstanceNotification();
        notification.setWorkflowInstanceKey(workflowInstanceKey);
        notification.setWorkflowKey(workflowKey);
        notification.setType(WorkflowInstanceNotification.Type.REMOVED);
        this.sendNotification(notification);
    }

    private void sendNotification(WorkflowInstanceNotification notification) {
        this.webSocket.convertAndSend((Object)"/notifications/workflow-instance", (Object)notification);
    }
}

