/*
 * Decompiled with CFR 0.152.
 */
package io.zerocopy.json.schema.merger;

import io.zerocopy.json.schema.SchemaProblem;
import java.util.Objects;

public class Problem
implements Comparable<Problem> {
    private SchemaProblem type;
    private Severity severity;
    private String message;

    public Problem() {
    }

    public Problem(SchemaProblem type, Severity severity, String message) {
        this.type = type;
        this.severity = severity;
        this.message = message;
    }

    public Problem(SchemaProblem type, Severity severity) {
        this(type, severity, null);
    }

    public SchemaProblem getType() {
        return this.type;
    }

    public void setType(SchemaProblem type) {
        this.type = type;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public int compareTo(Problem problem) {
        int d = this.type.compareTo((Enum)problem.type);
        if (d != 0) {
            return d;
        }
        d = this.severity.compareTo(problem.severity);
        if (d != 0) {
            return d;
        }
        d = this.message == null || problem.message == null ? (this.message == problem.message ? 0 : (this.message == null ? -1 : 1)) : this.message.compareTo(problem.message);
        return d;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Problem problem = (Problem)o;
        return this.type == problem.type && this.severity == problem.severity && Objects.equals(this.message, problem.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.severity, this.message});
    }

    public String toString() {
        return "Problem{type=" + this.type + ", severity=" + (Object)((Object)this.severity) + ", message='" + this.message + '\'' + '}';
    }

    public static enum Severity {
        ERROR,
        WARNING,
        INFO;

    }
}

