/*
 * Decompiled with CFR 0.152.
 */
package io.zerocopy.json.schema.merger;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.zerocopy.json.schema.JsonSchemaV7;
import io.zerocopy.json.schema.SchemaException;
import io.zerocopy.json.schema.SchemaProblem;
import io.zerocopy.json.schema.SchemaRecursionException;
import io.zerocopy.json.schema.SchemaUtils;
import io.zerocopy.json.schema.context.SchemaResolutionContext;
import io.zerocopy.json.schema.document.SchemaDocument;
import io.zerocopy.json.schema.document.SchemaReference;
import io.zerocopy.json.schema.merger.Problem;
import io.zerocopy.json.schema.merger.Result;
import io.zerocopy.json.schema.merger.SchemaMergerUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class SchemaMerger {
    private SchemaResolutionContext context = new SchemaResolutionContext();
    public static final Set<Option> OPTION_SET_MERGING_ACROSS_RULES = Collections.unmodifiableSet(EnumSet.of(Option.MERGE_CONST_INTO_ENUM, Option.MERGE_SINGLE_ANY_OF_TO_ALL_OF, Option.MERGE_SINGLE_ONE_OF_TO_ALL_OF));
    public static final Set<Option> OPTION_SET_MINIMIZE;
    public static final EnumSet<Option> DEFAULT_OPTIONS;
    private final Set<Option> options;

    public SchemaMerger(Set<Option> options) {
        this.options = options != null ? options : Collections.emptySet();
    }

    public SchemaMerger() {
        this(DEFAULT_OPTIONS);
    }

    public Result<JsonNode> merge(Collection<SchemaReference> schemas) throws IOException {
        return this.merge(false, schemas);
    }

    private Result<JsonNode> merge(boolean firstIsMerged, Collection<SchemaReference> schemas) throws IOException {
        JsonNode mergedSchemaNode;
        if (schemas.size() == 0) {
            return null;
        }
        Result<JsonNode> mergeResult = new Result<JsonNode>();
        ArrayList<SchemaReference> schemaList = new ArrayList<SchemaReference>(schemas);
        JsonSchemaV7 result = null;
        if (!schemaList.isEmpty()) {
            if (firstIsMerged) {
                SchemaReference firstSchema = (SchemaReference)schemaList.remove(0);
                result = this.context.mapSchema(firstSchema.getSchema());
            }
            for (int i = 0; i < schemaList.size(); ++i) {
                SchemaReference schemaReference = (SchemaReference)schemaList.get(i);
                result = this.mergeV7(result, schemaReference, schemaList, mergeResult);
            }
        }
        if (result.booleanValidity == null) {
            mergedSchemaNode = SchemaUtils.OBJECT_MAPPER.valueToTree(result);
            if (mergedSchemaNode.isObject()) {
                ((ObjectNode)mergedSchemaNode).remove("$schema");
            }
        } else {
            mergedSchemaNode = JsonNodeFactory.instance.booleanNode(result.booleanValidity.booleanValue());
        }
        if (mergedSchemaNode.getNodeType() != JsonNodeType.OBJECT || mergedSchemaNode.size() > 0) {
            mergeResult.setSchema(mergedSchemaNode);
        }
        return mergeResult;
    }

    public Result<SchemaDocument> mergeDocuments(Collection<SchemaDocument> schemaDocuments) throws IOException {
        Result<SchemaDocument> mergeResult = new Result<SchemaDocument>();
        SchemaDocument resultDocument = new SchemaDocument();
        LinkedHashMap<JsonPointer, List<SchemaReference>> schemas = new LinkedHashMap<JsonPointer, List<SchemaReference>>();
        HashSet schemaParents = new HashSet();
        for (SchemaDocument schemaDocument : schemaDocuments) {
            JsonNode documentRoot = schemaDocument.getRoot();
            if (!schemaDocument.getSchemaParentMap().isEmpty()) {
                schemaParents.addAll(schemaDocument.getSchemaParents());
                for (Map.Entry schemaRootEntry : schemaDocument.getSchemaParentMap().entrySet()) {
                    Iterator it = ((JsonNode)schemaRootEntry.getValue()).fields();
                    while (it.hasNext()) {
                        Map.Entry schemaEntry = (Map.Entry)it.next();
                        JsonPointer schemaPointer = ((JsonPointer)schemaRootEntry.getKey()).append(JsonPointer.compile((String)("/" + (String)schemaEntry.getKey())));
                        JsonNode schema = (JsonNode)schemaEntry.getValue();
                        SchemaMerger.addSchema(mergeResult, schemas, documentRoot, schemaPointer, schema);
                    }
                }
                continue;
            }
            JsonPointer schemaPointer = JsonPointer.compile((String)"");
            SchemaMerger.addSchema(mergeResult, schemas, documentRoot, schemaPointer, documentRoot);
        }
        for (Map.Entry entry : schemas.entrySet()) {
            Result<JsonNode> mergedSchema = this.merge((Collection)entry.getValue());
            mergeResult.addProblems(mergedSchema.getProblems());
            SchemaMergerUtils.putNode(resultDocument, (JsonPointer)entry.getKey(), mergedSchema.getSchema());
        }
        resultDocument.setSchemaParents(schemaParents);
        mergeResult.setSchema(resultDocument);
        return mergeResult;
    }

    private static void addSchema(Result<SchemaDocument> mergeResult, Map<JsonPointer, List<SchemaReference>> schemas, JsonNode documentRoot, JsonPointer schemaPointer, JsonNode schema) {
        if (schema != null) {
            List<SchemaReference> schemaReferences = schemas.get(schemaPointer);
            if (schemaReferences == null) {
                schemaReferences = new ArrayList<SchemaReference>();
                schemas.put(schemaPointer, schemaReferences);
            }
            schemaReferences.add(new SchemaReference(documentRoot, schemaPointer, schema));
        } else {
            mergeResult.addProblem(new Problem(SchemaProblem.INVALID_REF, Problem.Severity.WARNING, "no data at: " + schemaPointer));
        }
    }

    private JsonNode mergeNode(boolean firstIsMerged, Collection<SchemaReference> schemaReferences) throws IOException {
        Result<JsonNode> schemaReference = this.merge(firstIsMerged, schemaReferences);
        return schemaReference != null ? schemaReference.getSchema() : null;
    }

    private JsonNode mergeNode(boolean firstIsMerged, SchemaReference ... schemaReferences) throws IOException {
        return this.mergeNode(firstIsMerged, Arrays.asList(schemaReferences));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private JsonSchemaV7 mergeV7(JsonSchemaV7 schemaA, SchemaReference schemaReferenceB, Collection<SchemaReference> schemasOut, Result<?> result) throws IOException {
        boolean schemaPushed = false;
        try {
            Set<JsonNode> required;
            Object ref;
            ObjectNode jsonNode;
            JsonNode refNode;
            SchemaReference resolvedSchema = schemaReferenceB;
            if (resolvedSchema.getSchema() instanceof ObjectNode && (refNode = (jsonNode = (ObjectNode)resolvedSchema.getSchema()).get("$ref")) != null && (ref = refNode.asText()) != null) {
                HashSet allRefsInSchema = new HashSet();
                SchemaUtils.findAllRefsInSchema((JsonNode)resolvedSchema.getRoot(), (JsonNode)resolvedSchema.getSchema(), allRefsInSchema);
                boolean isRecursive = false;
                for (String otherRef : allRefsInSchema) {
                    if (!("#" + schemaReferenceB.getSchemaPointer().toString()).startsWith(otherRef)) continue;
                    isRecursive = true;
                    break;
                }
                if (!isRecursive) {
                    LinkedList linkedList = new LinkedList();
                    try {
                        resolvedSchema = this.context.resolveSchema(schemaReferenceB.getRoot(), schemaReferenceB.getSchema(), (String)ref, linkedList, true);
                    }
                    catch (SchemaRecursionException e) {
                        resolvedSchema = new SchemaReference(e.getSchemaReference().getRoot(), e.getSchemaReference().getSchemaPointer());
                    }
                }
                if (resolvedSchema != null) {
                    schemaReferenceB = resolvedSchema;
                } else {
                    throw new SchemaException(SchemaProblem.INVALID_REF, "failed to resolve $ref: " + (String)ref);
                }
            }
            if (schemaA == null) {
                schemaA = new JsonSchemaV7();
            }
            JsonSchemaV7 schemaB = this.context.pushSchemaReference(schemaReferenceB);
            schemaPushed = true;
            if (schemaB.ref != null) {
                int nRefs = 0;
                boolean isNewRef = true;
                if (schemaA.ref != null) {
                    ++nRefs;
                    if (schemaA.ref.equals(schemaB.ref)) {
                        isNewRef = false;
                    }
                }
                if (isNewRef && schemaA.allOf != null) {
                    for (JsonNode jsonNode2 : schemaA.allOf) {
                        JsonNode refNode2;
                        if (!jsonNode2.isObject() || (refNode2 = jsonNode2.get("$ref")) == null) continue;
                        ++nRefs;
                        if (!refNode2.asText().equals(schemaB.ref)) continue;
                        isNewRef = false;
                    }
                }
                if (isNewRef) {
                    if (nRefs == 0 && SchemaUtils.OBJECT_MAPPER.valueToTree((Object)schemaA).size() == 0) {
                        schemaA.ref = schemaB.ref;
                    } else {
                        if (schemaA.allOf == null) {
                            schemaA.allOf = JsonNodeFactory.instance.arrayNode();
                        }
                        if (schemaA.ref != null) {
                            schemaA.allOf.add((JsonNode)JsonNodeFactory.instance.objectNode().put("$ref", schemaA.ref));
                            schemaA.ref = null;
                        }
                        schemaA.allOf.add((JsonNode)JsonNodeFactory.instance.objectNode().put("$ref", schemaB.ref));
                    }
                }
                ref = schemaA;
                return ref;
            }
            if (schemaB.required != null && schemaB.required.size() > 0) {
                required = new LinkedHashSet<JsonNode>(schemaB.required.size() + (schemaA.required != null ? schemaA.required.size() : 0));
                if (schemaA.required != null) {
                    for (JsonNode jsonNode3 : schemaA.required) {
                        required.add((JsonNode)jsonNode3.textValue());
                    }
                }
                for (JsonNode jsonNode2 : schemaB.required) {
                    required.add((JsonNode)jsonNode2.textValue());
                }
                if (schemaA.required == null) {
                    schemaA.required = JsonNodeFactory.instance.arrayNode(required.size());
                } else {
                    schemaA.required.removeAll();
                }
                for (Object requiredProperty : required) {
                    schemaA.required.add((String)requiredProperty);
                }
                schemaB.required = null;
            } else if (schemaA.required != null) {
                required = new HashSet<JsonNode>(schemaA.required.size());
                for (Object requiredProperty : schemaA.required) {
                    required.add((JsonNode)requiredProperty.asText());
                }
            } else {
                required = Collections.emptySet();
            }
            JsonNode additionalProperties = schemaA.additionalProperties;
            if (schemaB.additionalProperties != null) {
                if (schemaB.additionalProperties.isBoolean()) {
                    if (!schemaB.additionalProperties.asBoolean()) {
                        additionalProperties = schemaB.additionalProperties;
                    }
                } else {
                    additionalProperties = schemaA.additionalProperties != null ? this.mergeNode(true, new SchemaReference(schemaA.additionalProperties), new SchemaReference(schemaReferenceB.getRoot(), schemaReferenceB.getSchemaPointer().append(JsonPointer.compile((String)"/additionalProperties/")), schemaB.additionalProperties)) : this.mergeNode(false, new SchemaReference(schemaReferenceB.getRoot(), schemaReferenceB.getSchemaPointer().append(JsonPointer.compile((String)"/additionalProperties")), schemaB.additionalProperties));
                }
            }
            if (schemaB.properties != null) {
                LinkedHashSet allKeys = new LinkedHashSet();
                ObjectNode mergedProperties = JsonNodeFactory.instance.objectNode();
                if (schemaA.properties != null) {
                    if (!schemaA.properties.isObject()) {
                        throw new SchemaException(SchemaProblem.TYPE_ERROR, "/properties is not an object");
                    }
                    Iterator it = schemaA.properties.fieldNames();
                    while (it.hasNext()) {
                        allKeys.add(it.next());
                    }
                }
                Iterator it = schemaB.properties.fieldNames();
                while (it.hasNext()) {
                    allKeys.add(it.next());
                }
                allKeys.addAll(required);
                for (String string : allKeys) {
                    boolean redundantToAdditionalProperties;
                    JsonNode mergedPropertySchema;
                    JsonNode valueA = schemaA.properties != null ? schemaA.properties.get(string) : null;
                    JsonNode valueB = schemaB.properties.get(string);
                    ArrayList<SchemaReference> propertySchemas = new ArrayList<SchemaReference>();
                    if (valueA == null && valueB == null) continue;
                    if (valueA != null) {
                        propertySchemas.add(new SchemaReference(valueA));
                    }
                    if (valueB != null) {
                        propertySchemas.add(new SchemaReference(schemaReferenceB.getRoot(), schemaReferenceB.getSchemaPointer().append(JsonPointer.compile((String)("/properties/" + string))), valueB));
                    }
                    if (valueB == null && schemaB.additionalProperties != null) {
                        propertySchemas.add(new SchemaReference(schemaReferenceB.getRoot(), schemaReferenceB.getSchemaPointer().append(JsonPointer.compile((String)"/additionalProperties")), schemaB.additionalProperties));
                    }
                    if (valueA == null && schemaA.additionalProperties != null) {
                        propertySchemas.add(new SchemaReference(schemaA.additionalProperties));
                    }
                    if ((mergedPropertySchema = this.mergeNode(valueA != null, propertySchemas)) == null) continue;
                    boolean bl = redundantToAdditionalProperties = this.options.contains((Object)Option.REMOVE_PROPERTIES_THAT_MATCH_ADDITIONAL_PROPERTIES) && SchemaMergerUtils.eq(mergedPropertySchema, additionalProperties);
                    if (!redundantToAdditionalProperties) {
                        mergedProperties.set(string, mergedPropertySchema);
                    }
                    if (!mergedPropertySchema.isBoolean() || mergedPropertySchema.asBoolean() || !required.contains(string)) continue;
                    result.addProblem(new Problem(SchemaProblem.VALIDATION_ALWAYS_FAILS, Problem.Severity.WARNING, "required property will never pass validation: " + string));
                }
                schemaA.properties = mergedProperties;
                schemaB.properties = null;
            }
            schemaA.additionalProperties = additionalProperties;
            schemaB.additionalProperties = null;
            if (schemaB.pattern != null) {
                boolean newPattern = true;
                int nPatterns = 0;
                if (schemaA.pattern != null) {
                    ++nPatterns;
                    boolean bl = newPattern = !Objects.equals(schemaA.pattern.pattern(), schemaB.pattern.pattern());
                }
                if (newPattern && schemaA.allOf != null) {
                    for (JsonNode jsonNode3 : schemaA.allOf) {
                        if (!jsonNode3.has("pattern")) continue;
                        ++nPatterns;
                        if (!jsonNode3.get("pattern").asText().equals(schemaB.pattern.pattern())) continue;
                        newPattern = false;
                        break;
                    }
                }
                if (newPattern) {
                    if (nPatterns > 0) {
                        if (schemaA.allOf == null) {
                            schemaA.allOf = JsonNodeFactory.instance.arrayNode(1);
                        }
                        if (schemaA.pattern != null) {
                            schemaA.allOf.add((JsonNode)JsonNodeFactory.instance.objectNode().put("pattern", schemaA.pattern.pattern()));
                            schemaA.pattern = null;
                        }
                        schemaA.allOf.add((JsonNode)JsonNodeFactory.instance.objectNode().put("pattern", schemaB.pattern.pattern()));
                    } else {
                        schemaA.pattern = schemaB.pattern;
                    }
                }
                schemaB.pattern = null;
            }
            schemaA.minLength = SchemaMergerUtils.max(schemaA.minLength, schemaB.minLength);
            schemaA.maxLength = SchemaMergerUtils.min(schemaA.maxLength, schemaB.maxLength);
            schemaB.minLength = null;
            schemaB.maxLength = null;
            if (schemaB.patternProperties != null) {
                for (Map.Entry nodeEntry : schemaB.patternProperties.entrySet()) {
                    if (schemaA.patternProperties == null) {
                        schemaA.patternProperties = new TreeMap(SchemaUtils.PATTERN_COMPARATOR);
                    }
                    Map mergedProperties = schemaA.patternProperties;
                    JsonNode jsonNode4 = (JsonNode)nodeEntry.getValue();
                    JsonNode existing = (JsonNode)mergedProperties.get(nodeEntry.getKey());
                    if (existing != null) {
                        mergedProperties.put(nodeEntry.getKey(), this.mergeNode(true, new SchemaReference(existing), new SchemaReference(schemaReferenceB.getRoot(), schemaReferenceB.getSchemaPointer().append(JsonPointer.compile((String)("/patternProperties/" + nodeEntry.getKey()))), jsonNode4)));
                        continue;
                    }
                    mergedProperties.put(nodeEntry.getKey(), this.mergeNode(false, new SchemaReference(schemaReferenceB.getRoot(), schemaReferenceB.getSchemaPointer().append(JsonPointer.compile((String)("/patternProperties/" + nodeEntry.getKey()))), jsonNode4)));
                }
                schemaB.patternProperties = null;
            }
            if (schemaB.booleanValidity != null) {
                if (schemaA.booleanValidity != null) {
                    if (!schemaA.booleanValidity.equals(schemaB.booleanValidity)) {
                        result.addProblem(new Problem(SchemaProblem.VALIDATION_ALWAYS_FAILS, Problem.Severity.WARNING));
                        schemaA = new JsonSchemaV7();
                        schemaA.booleanValidity = false;
                        JsonSchemaV7 newPattern = schemaA;
                        return newPattern;
                    }
                } else {
                    schemaA.booleanValidity = schemaB.booleanValidity;
                }
                schemaB.booleanValidity = null;
            }
            if (schemaB.nonSchemaProperties != null) {
                if (schemaA.nonSchemaProperties != null) {
                    schemaA.nonSchemaProperties.setAll(schemaB.nonSchemaProperties);
                } else {
                    schemaA.nonSchemaProperties = schemaB.nonSchemaProperties;
                }
                schemaB.nonSchemaProperties = null;
            }
            schemaA.type = SchemaMergerUtils.arrayIntersect(schemaA.type, schemaB.type);
            schemaB.type = null;
            schemaA.minProperties = SchemaMergerUtils.max(schemaA.minProperties, schemaB.minProperties);
            schemaA.maxProperties = SchemaMergerUtils.min(schemaA.maxProperties, schemaB.maxProperties);
            schemaB.minProperties = null;
            schemaB.maxProperties = null;
            if (schemaB.propertyNames != null) {
                schemaA.propertyNames = schemaA.propertyNames != null ? this.mergeNode(true, new SchemaReference(schemaA.propertyNames), new SchemaReference(schemaReferenceB.getRoot(), schemaReferenceB.getSchemaPointer().append(JsonPointer.compile((String)"/propertyNames")), schemaB.propertyNames)) : this.mergeNode(false, new SchemaReference(schemaReferenceB.getRoot(), schemaReferenceB.getSchemaPointer().append(JsonPointer.compile((String)"/propertyNames")), schemaB.propertyNames));
                schemaB.propertyNames = null;
            }
            if (schemaB.items != null) {
                if (schemaB.additionalItems != null && schemaB.additionalItems.size() == 0) {
                    schemaB.additionalItems = null;
                }
                if (schemaB.items.isArray() || schemaA.items != null && schemaA.items.isArray()) {
                    void var12_52;
                    int totalSchemaCount = 0;
                    if (schemaA.items != null && schemaA.items.isArray()) {
                        totalSchemaCount = Math.max(totalSchemaCount, schemaA.items.size());
                    }
                    if (schemaB.items.isArray()) {
                        totalSchemaCount = Math.max(totalSchemaCount, schemaB.items.size());
                    }
                    ArrayNode newItems = JsonNodeFactory.instance.arrayNode(totalSchemaCount);
                    ArrayList<SchemaReference> schemasAtIndex = new ArrayList<SchemaReference>(2);
                    boolean bl = false;
                    while (var12_52 < totalSchemaCount) {
                        JsonPointer itemSchemaPointer;
                        JsonNode item;
                        JsonNode existingItem = schemaA.items != null ? (schemaA.items.isArray() ? (var12_52 < schemaA.items.size() ? schemaA.items.get((int)var12_52) : schemaA.additionalItems) : schemaA.items) : null;
                        if (schemaB.items.isArray()) {
                            if (var12_52 < schemaB.items.size()) {
                                item = schemaB.items.get((int)var12_52);
                                itemSchemaPointer = schemaReferenceB.getSchemaPointer().append(JsonPointer.compile((String)("/items/" + (int)var12_52)));
                            } else {
                                item = schemaB.additionalItems;
                                itemSchemaPointer = schemaReferenceB.getSchemaPointer().append(JsonPointer.compile((String)"/additionalItems"));
                            }
                        } else {
                            item = schemaB.items;
                            itemSchemaPointer = schemaReferenceB.getSchemaPointer().append(JsonPointer.compile((String)"/items"));
                        }
                        schemasAtIndex.clear();
                        if (existingItem != null) {
                            schemasAtIndex.add(new SchemaReference(existingItem));
                        }
                        if (item != null) {
                            schemasAtIndex.add(new SchemaReference(schemaReferenceB.getRoot(), itemSchemaPointer, item));
                        }
                        JsonNode mergedSchemaAtIndex = this.mergeNode(existingItem != null, schemasAtIndex);
                        newItems.add(mergedSchemaAtIndex);
                        ++var12_52;
                    }
                    ArrayList<SchemaReference> arrayList = new ArrayList<SchemaReference>(2);
                    if (schemaA.additionalItems != null) {
                        arrayList.add(new SchemaReference(schemaA.additionalItems));
                    }
                    if (schemaB.additionalItems != null) {
                        arrayList.add(new SchemaReference(schemaReferenceB.getRoot(), JsonPointer.compile((String)"/additionalItems"), schemaB.additionalItems));
                    }
                    schemaA.additionalItems = this.mergeNode(schemaA.additionalItems != null, arrayList);
                    schemaA.items = newItems;
                } else {
                    ArrayList<SchemaReference> schemas = new ArrayList<SchemaReference>(2);
                    if (schemaA.items != null) {
                        schemas.add(new SchemaReference(schemaA.items));
                    }
                    schemas.add(new SchemaReference(schemaReferenceB.getRoot(), schemaReferenceB.getSchemaPointer().append(JsonPointer.compile((String)"/items")), schemaB.items));
                    schemaA.additionalItems = null;
                    schemaA.items = this.mergeNode(schemaA.items != null, schemas);
                }
            }
            schemaB.items = null;
            schemaB.additionalItems = null;
            schemaA.minItems = SchemaMergerUtils.max(schemaA.minItems, schemaB.minItems);
            schemaA.maxItems = SchemaMergerUtils.min(schemaA.maxItems, schemaB.maxItems);
            schemaA.minItems = null;
            schemaA.maxItems = null;
            schemaA.minimum = SchemaMergerUtils.max(schemaA.minimum, schemaB.minimum);
            schemaA.exclusiveMinimum = SchemaMergerUtils.max(schemaA.exclusiveMinimum, schemaB.exclusiveMinimum);
            schemaA.maximum = SchemaMergerUtils.min(schemaA.maximum, schemaB.maximum);
            schemaA.exclusiveMaximum = SchemaMergerUtils.min(schemaA.exclusiveMaximum, schemaB.exclusiveMaximum);
            schemaA.multipleOf = SchemaMergerUtils.lcm(schemaA.multipleOf, schemaB.multipleOf);
            schemaB.minimum = null;
            schemaB.exclusiveMinimum = null;
            schemaB.maximum = null;
            schemaB.exclusiveMaximum = null;
            schemaB.multipleOf = null;
            if (schemaB._enum != null) {
                schemaA._enum = SchemaMergerUtils.arrayIntersectUnique(schemaA._enum, schemaB._enum);
                schemaB._enum = null;
            }
            if (schemaB._const != null) {
                if (schemaA._const != null && !SchemaMergerUtils.eq(schemaA._const, schemaB._const)) {
                    result.addProblem(new Problem(SchemaProblem.VALIDATION_ALWAYS_FAILS, Problem.Severity.WARNING));
                    schemaA = new JsonSchemaV7();
                    schemaA.booleanValidity = false;
                    JsonSchemaV7 schemas = schemaA;
                    return schemas;
                }
                schemaA._const = schemaB._const;
                schemaB._const = null;
            }
            if (schemaA._enum != null && schemaA._const != null) {
                boolean constInEnum = false;
                for (JsonNode enumValue : schemaA._enum) {
                    if (!schemaA._const.equals((Object)enumValue)) continue;
                    constInEnum = true;
                    break;
                }
                if (constInEnum) {
                    if (this.options.contains((Object)Option.MERGE_CONST_INTO_ENUM)) {
                        schemaA._enum.removeAll();
                        schemaA._enum.add(schemaA._const);
                        schemaA._const = null;
                    } else {
                        schemaA._enum = null;
                    }
                } else {
                    result.addProblem(new Problem(SchemaProblem.VALIDATION_ALWAYS_FAILS, Problem.Severity.WARNING, null));
                }
            }
            if (schemaB.allOf != null) {
                int i = 0;
                for (JsonNode subSchema : schemaB.allOf) {
                    schemasOut.add(new SchemaReference(schemaReferenceB.getRoot(), schemaReferenceB.getSchemaPointer().append(JsonPointer.compile((String)("/allOf/" + i))), subSchema));
                    ++i;
                }
                schemaB.allOf = null;
            }
            if (schemaB.anyOf != null) {
                if (this.options.contains((Object)Option.MERGE_SINGLE_ANY_OF_TO_ALL_OF) && schemaB.anyOf.size() == 1) {
                    schemasOut.add(new SchemaReference(schemaReferenceB.getRoot(), schemaReferenceB.getSchemaPointer().append(JsonPointer.compile((String)"/anyOf/0")), schemaB.anyOf.get(0)));
                    schemaB.anyOf = null;
                } else {
                    ArrayNode newAnyOf = null;
                    int i = 0;
                    for (JsonNode jsonNode5 : schemaB.anyOf) {
                        JsonNode jsonNode6 = this.mergeNode(false, new SchemaReference(schemaReferenceB.getRoot(), schemaReferenceB.getSchemaPointer().append(JsonPointer.compile((String)("/anyOf/" + i))), jsonNode5));
                        newAnyOf = SchemaMergerUtils.arrayAddUnique(newAnyOf, jsonNode6);
                        ++i;
                    }
                    schemaB.anyOf = newAnyOf;
                }
            }
            if (schemaB.oneOf != null) {
                if (this.options.contains((Object)Option.MERGE_SINGLE_ONE_OF_TO_ALL_OF) && schemaB.oneOf.size() == 1) {
                    schemasOut.add(new SchemaReference(schemaReferenceB.getRoot(), schemaReferenceB.getSchemaPointer().append(JsonPointer.compile((String)"/oneOf/0")), schemaB.oneOf.get(0)));
                    schemaB.oneOf = null;
                } else {
                    ArrayNode newOneOf = null;
                    int i = 0;
                    for (JsonNode jsonNode7 : schemaB.oneOf) {
                        JsonNode jsonNode8 = this.mergeNode(false, new SchemaReference(schemaReferenceB.getRoot(), schemaReferenceB.getSchemaPointer().append(JsonPointer.compile((String)("/oneOf/" + i))), jsonNode7));
                        newOneOf = SchemaMergerUtils.arrayAddUnique(newOneOf, jsonNode8);
                        ++i;
                    }
                    schemaB.oneOf = newOneOf;
                }
            }
            schemaB.description = null;
            schemaB.schema = null;
            schemaB.nonSchemaProperties = null;
            JsonNode remainderSchemaNode = SchemaUtils.OBJECT_MAPPER.valueToTree((Object)schemaB);
            if (!remainderSchemaNode.isObject() || remainderSchemaNode.size() > 0) {
                schemaA.allOf = SchemaMergerUtils.arrayAddUnique(schemaA.allOf, remainderSchemaNode);
            }
            JsonSchemaV7 jsonSchemaV7 = schemaA;
            return jsonSchemaV7;
        }
        finally {
            if (schemaPushed) {
                this.context.popSchemaReference(schemaReferenceB);
            }
        }
    }

    static {
        EnumSet<Option> minimizeOptions = EnumSet.copyOf(OPTION_SET_MERGING_ACROSS_RULES);
        minimizeOptions.add(Option.REMOVE_PROPERTIES_THAT_MATCH_ADDITIONAL_PROPERTIES);
        OPTION_SET_MINIMIZE = Collections.unmodifiableSet(minimizeOptions);
        DEFAULT_OPTIONS = EnumSet.noneOf(Option.class);
    }

    public static enum Option {
        MERGE_CONST_INTO_ENUM,
        MERGE_SINGLE_ANY_OF_TO_ALL_OF,
        MERGE_SINGLE_ONE_OF_TO_ALL_OF,
        REMOVE_PROPERTIES_THAT_MATCH_ADDITIONAL_PROPERTIES;

    }
}

