/*
 * Decompiled with CFR 0.152.
 */
package io.zerocopy.json.schema.merger;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.zerocopy.json.schema.document.SchemaDocument;
import io.zerocopy.json.schema.pointer.JsonPointerUtils;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SchemaMergerUtils {
    public static BigDecimal scalarToBigInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Number) {
            return new BigDecimal(value.toString());
        }
        return new BigDecimal(value.toString());
    }

    public static Object scalar(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Number) {
            return new BigDecimal(value.toString());
        }
        return value;
    }

    public static boolean eq(JsonNode a, JsonNode b) {
        return Objects.equals(a, b);
    }

    public static BigDecimal max(BigDecimal a, BigDecimal b) {
        if (b != null) {
            a = a != null ? a.max(b) : b;
        }
        return a;
    }

    public static BigDecimal min(BigDecimal a, BigDecimal b) {
        if (b != null) {
            a = a != null ? a.min(b) : b;
        }
        return a;
    }

    public static BigDecimal gcd(BigDecimal a, BigDecimal b) {
        while (b.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal temp = b;
            b = a.divideAndRemainder(b)[1];
            a = temp;
        }
        return a;
    }

    public static BigDecimal lcm(BigDecimal a, BigDecimal b) {
        if (b != null) {
            if (a != null) {
                return a.multiply(b.divide(SchemaMergerUtils.gcd(a, b), 7));
            }
            a = b;
        }
        return a;
    }

    public static Integer max(Integer a, Integer b) {
        if (b != null) {
            a = a != null ? Integer.valueOf(Math.max(a, b)) : b;
        }
        return a;
    }

    public static Integer min(Integer a, Integer b) {
        if (b != null) {
            a = a != null ? Integer.valueOf(Math.min(a, b)) : b;
        }
        return a;
    }

    public static <T> T[] arrayIntersect(T[] a, T[] b) {
        if (b != null) {
            if (a != null) {
                Set<Object> intersection = SchemaMergerUtils.collectionIntersect(Arrays.asList(a), Arrays.asList(b));
                return intersection.toArray((Object[])Array.newInstance(a.getClass().getComponentType(), intersection.size()));
            }
            return b;
        }
        return a;
    }

    public static <T> Set<T> collectionIntersect(Collection<T> ... collections) {
        LinkedHashSet<T> intersection = new LinkedHashSet<T>();
        int count = 0;
        for (Collection<T> collection : collections) {
            if (collection == null) continue;
            if (count++ == 0) {
                intersection.addAll(collection);
                continue;
            }
            intersection.retainAll(collection);
        }
        return intersection;
    }

    public static void putNode(SchemaDocument outputSchema, JsonPointer pointer, JsonNode value) {
        List pathElems;
        ObjectNode node = (ObjectNode)outputSchema.getRoot();
        if (node == null) {
            node = JsonNodeFactory.instance.objectNode();
            outputSchema.setRoot((JsonNode)node);
        }
        if ((pathElems = JsonPointerUtils.split((String)pointer.toString())).size() > 0) {
            for (int i = 0; i < pathElems.size() - 1; ++i) {
                JsonNode oldNode;
                String elem = (String)pathElems.get(i);
                ObjectNode childNode = (ObjectNode)node.get(elem);
                if (childNode == null && (oldNode = node.replace(elem, (JsonNode)(childNode = JsonNodeFactory.instance.objectNode()))) != null && oldNode != childNode) {
                    throw new IllegalArgumentException("duplicate node at " + pointer);
                }
                node = childNode;
            }
            node.set((String)pathElems.get(pathElems.size() - 1), value);
        } else {
            outputSchema.setRoot(value);
        }
    }

    public static ArrayNode arrayAddUnique(ArrayNode arrayNode, JsonNode element) {
        if (arrayNode != null) {
            for (JsonNode existingElement : arrayNode) {
                if (!SchemaMergerUtils.eq(element, existingElement)) continue;
                return arrayNode;
            }
        } else {
            arrayNode = JsonNodeFactory.instance.arrayNode(1);
        }
        arrayNode.add(element);
        return arrayNode;
    }

    public static ArrayNode arrayMergeUnique(ArrayNode a, ArrayNode b) {
        ArrayNode result;
        Object object = result = a != null || b != null ? JsonNodeFactory.instance.arrayNode() : null;
        if (a != null) {
            for (JsonNode element : a) {
                result = SchemaMergerUtils.arrayAddUnique(result, element);
            }
        }
        if (b != null) {
            for (JsonNode element : b) {
                result = SchemaMergerUtils.arrayAddUnique(result, element);
            }
        }
        return result;
    }

    public static ArrayNode arrayUnique(ArrayNode arrayNode) {
        return SchemaMergerUtils.arrayMergeUnique(null, arrayNode);
    }

    public static ArrayNode arrayIntersectUnique(ArrayNode a, ArrayNode b) {
        if (a == null && b == null) {
            return null;
        }
        ArrayNode result = JsonNodeFactory.instance.arrayNode();
        if (a != null && b != null) {
            block0: for (JsonNode elemA : a) {
                for (JsonNode elemB : b) {
                    if (!SchemaMergerUtils.eq(elemA, elemB)) continue;
                    SchemaMergerUtils.arrayAddUnique(result, elemA);
                    continue block0;
                }
            }
        } else {
            result = SchemaMergerUtils.arrayMergeUnique(result, a != null ? a : b);
        }
        return result;
    }
}

