/*
 * Decompiled with CFR 0.152.
 */
package io.zerocopy.json.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.zerocopy.json.schema.JsonSchema;
import io.zerocopy.json.schema.JsonSchemaV7;
import io.zerocopy.json.schema.SchemaException;
import io.zerocopy.json.schema.SchemaProblem;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class JsonSchemaDeserializer {
    private static final Set<URI> supportedSchemas = new HashSet<URI>();
    private static final Comparator<Pattern> PATTERN_COMPARATOR;

    public static JsonSchemaV7 mapSchema(URI defaultSchemaVersion, JsonNode schemaNode) {
        JsonSchemaV7 schema = new JsonSchemaV7();
        if (schemaNode == null) {
            throw new NullPointerException();
        }
        if (!schemaNode.isObject() && !schemaNode.isBoolean()) {
            throw new IllegalArgumentException("invalid node type: " + schemaNode.getNodeType());
        }
        if (schemaNode.isObject()) {
            JsonNode idNode;
            URI schemaVersionUri;
            ObjectNode node = JsonNodeFactory.instance.objectNode();
            node.setAll((ObjectNode)schemaNode);
            String schemaVersion = JsonSchemaDeserializer.string(node.remove("$schema"));
            if (schemaVersion != null) {
                schemaVersionUri = URI.create(schemaVersion).normalize();
                if (!supportedSchemas.contains(schemaVersionUri)) {
                    throw new SchemaException(SchemaProblem.UNSUPPORTED_SCHEMA_VERSION, "Unsupported schema: " + schemaVersionUri);
                }
            } else {
                URI uRI = schemaVersionUri = defaultSchemaVersion != null ? defaultSchemaVersion.normalize() : null;
            }
            if (JsonSchema.DRAFT_4.equals(schemaVersionUri)) {
                schema.id = JsonSchemaDeserializer.string(node.remove("id"));
            } else if (JsonSchema.DRAFT_6.equals(schemaVersionUri) || JsonSchema.DRAFT_7.equals(schemaVersionUri)) {
                schema.id = JsonSchemaDeserializer.string(node.remove("$id"));
            } else if (schemaVersionUri == null && (idNode = node.remove("id")) != null) {
                schema.id = JsonSchemaDeserializer.string(idNode);
                if (schema.id != null) {
                    schemaVersionUri = JsonSchema.DRAFT_4;
                } else {
                    schema.id = JsonSchemaDeserializer.string(node.remove("$id"));
                }
            }
            schema.ref = JsonSchemaDeserializer.string(node.remove("$ref"));
            JsonNode typeNode = node.remove("type");
            if (typeNode != null) {
                if (typeNode.isTextual()) {
                    schema.type = new JsonSchemaV7.Type[]{JsonSchemaV7.Type.forValue(JsonSchemaDeserializer.string(typeNode))};
                } else if (typeNode.isArray()) {
                    schema.type = new JsonSchemaV7.Type[typeNode.size()];
                    int i = 0;
                    for (JsonNode typeElement : typeNode) {
                        schema.type[i++] = JsonSchemaV7.Type.forValue(JsonSchemaDeserializer.string(typeElement));
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }
            schema.title = JsonSchemaDeserializer.string(node.remove("title"));
            schema.description = JsonSchemaDeserializer.string(node.remove("description"));
            if (JsonSchema.DRAFT_7.equals(schemaVersionUri)) {
                schema.comment = JsonSchemaDeserializer.string(node.remove("comment"));
            }
            if (JsonSchema.DRAFT_6.equals(schemaVersionUri) || JsonSchema.DRAFT_7.equals(schemaVersionUri)) {
                schema.examples = JsonSchemaDeserializer.array(node.remove("examples"));
            }
            if (JsonSchema.DRAFT_6.equals(schemaVersionUri) || JsonSchema.DRAFT_7.equals(schemaVersionUri)) {
                schema._const = node.remove("const");
            }
            schema._default = node.remove("default");
            schema._enum = JsonSchemaDeserializer.array(node.remove("enum"));
            schema.allOf = JsonSchemaDeserializer.array(node.remove("allOf"));
            schema.anyOf = JsonSchemaDeserializer.array(node.remove("anyOf"));
            schema.oneOf = JsonSchemaDeserializer.array(node.remove("oneOf"));
            schema.not = node.remove("not");
            schema.maxProperties = JsonSchemaDeserializer.integer(node.remove("maxProperties"));
            schema.minProperties = JsonSchemaDeserializer.integer(node.remove("minProperties"));
            schema.properties = (ObjectNode)node.remove("properties");
            schema.required = JsonSchemaDeserializer.array(node.remove("required"));
            schema.patternProperties = JsonSchemaDeserializer.getPatternProperties(node.remove("patternProperties"));
            schema.additionalProperties = node.remove("additionalProperties");
            schema.dependencies = node.remove("dependencies");
            if (JsonSchema.DRAFT_6.equals(schemaVersionUri) || JsonSchema.DRAFT_7.equals(schemaVersionUri)) {
                schema.propertyNames = node.remove("propertyNames");
            }
            schema.items = node.remove("items");
            schema.additionalItems = node.remove("additionalItems");
            schema.minItems = JsonSchemaDeserializer.integer(node.remove("minItems"));
            schema.maxItems = JsonSchemaDeserializer.integer(node.remove("maxItems"));
            schema.uniqueItems = JsonSchemaDeserializer.bool(node.remove("uniqueItems"));
            if (JsonSchema.DRAFT_6.equals(schemaVersionUri) || JsonSchema.DRAFT_7.equals(schemaVersionUri)) {
                schema.contains = node.remove("contains");
            }
            schema.format = JsonSchemaV7.Format.forValue(JsonSchemaDeserializer.string(node.remove("format")));
            schema.pattern = JsonSchemaDeserializer.pattern(node.remove("pattern"));
            schema.minLength = JsonSchemaDeserializer.integer(node.remove("minLength"));
            schema.maxLength = JsonSchemaDeserializer.integer(node.remove("maxLength"));
            schema.contentMediaType = JsonSchemaDeserializer.string(node.remove("contentMediaType"));
            schema.contentEncoding = JsonSchemaDeserializer.string(node.remove("contentEncoding"));
            schema.minimum = JsonSchemaDeserializer.dec(node.remove("minimum"));
            schema.maximum = JsonSchemaDeserializer.dec(node.remove("maximum"));
            JsonNode exclusiveMinimumNode = node.remove("exclusiveMinimum");
            JsonNode exclusiveMaximumNode = node.remove("exclusiveMaximum");
            if (schemaVersionUri == null && (exclusiveMinimumNode != null && exclusiveMinimumNode.isBoolean() || exclusiveMaximumNode != null && exclusiveMaximumNode.isBoolean())) {
                schemaVersionUri = JsonSchema.DRAFT_4;
            }
            if (JsonSchema.DRAFT_4.equals(schemaVersionUri)) {
                if (JsonSchemaDeserializer.bool(exclusiveMinimumNode) == Boolean.TRUE) {
                    schemaVersionUri = JsonSchema.DRAFT_4;
                    schema.exclusiveMinimum = schema.minimum;
                    schema.minimum = null;
                }
                if (JsonSchemaDeserializer.bool(exclusiveMaximumNode) == Boolean.TRUE) {
                    schemaVersionUri = JsonSchema.DRAFT_4;
                    schema.exclusiveMaximum = schema.maximum;
                    schema.maximum = null;
                }
            } else {
                schema.exclusiveMinimum = JsonSchemaDeserializer.dec(exclusiveMinimumNode);
                schema.exclusiveMaximum = JsonSchemaDeserializer.dec(exclusiveMaximumNode);
            }
            schema.multipleOf = JsonSchemaDeserializer.dec(node.remove("multipleOf"));
            if (JsonSchema.DRAFT_7.equals(schemaVersionUri)) {
                schema._if = node.remove("if");
                schema._then = node.remove("then");
                schema._else = node.remove("else");
            }
            if (JsonSchema.DRAFT_4.equals(schemaVersionUri)) {
                schema.numberWithZeroFractionAsInteger = false;
            }
            if (JsonSchema.DRAFT_7.equals(schemaVersionUri)) {
                schema.readOnly = JsonSchemaDeserializer.bool(node.remove("readOnly"));
                schema.writeOnly = JsonSchemaDeserializer.bool(node.remove("writeOnly"));
            }
            schema.nonSchemaProperties = node;
            schema.schema = schemaVersionUri;
        } else if (schemaNode.isBoolean()) {
            schema.booleanValidity = schemaNode.asBoolean();
        } else {
            throw new SchemaException(SchemaProblem.TYPE_ERROR, "unsupported node type: " + schemaNode.getNodeType());
        }
        return schema;
    }

    private static Map<Pattern, JsonNode> getPatternProperties(JsonNode node) {
        if (node == null) {
            return null;
        }
        if (!node.isObject()) {
            throw new SchemaException(SchemaProblem.TYPE_ERROR, "not an object");
        }
        TreeMap<Pattern, JsonNode> map = new TreeMap<Pattern, JsonNode>(PATTERN_COMPARATOR);
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry propertyEntry = (Map.Entry)it.next();
            Pattern pattern = Pattern.compile((String)propertyEntry.getKey());
            map.put(pattern, (JsonNode)propertyEntry.getValue());
        }
        return map;
    }

    private static String string(JsonNode node) {
        if (node == null) {
            return null;
        }
        if (!node.isTextual()) {
            throw new SchemaException(SchemaProblem.TYPE_ERROR, "not a string");
        }
        return node.asText();
    }

    private static Boolean bool(JsonNode node) {
        if (node == null) {
            return null;
        }
        if (!node.isBoolean()) {
            throw new SchemaException(SchemaProblem.TYPE_ERROR, "not a boolean");
        }
        return node.asBoolean();
    }

    private static Integer integer(JsonNode node) {
        if (node == null) {
            return null;
        }
        if (!node.isInt()) {
            throw new SchemaException(SchemaProblem.TYPE_ERROR, "not an integer");
        }
        return node.asInt();
    }

    private static BigDecimal dec(JsonNode node) {
        if (node == null) {
            return null;
        }
        if (!node.isNumber()) {
            throw new SchemaException(SchemaProblem.TYPE_ERROR, "not a number");
        }
        return node.decimalValue();
    }

    private static ArrayNode array(JsonNode node) {
        if (node == null) {
            return null;
        }
        if (!node.isArray()) {
            throw new SchemaException(SchemaProblem.TYPE_ERROR, "not an array");
        }
        return (ArrayNode)node;
    }

    private static Pattern pattern(JsonNode node) {
        if (node == null) {
            return null;
        }
        if (!node.isTextual()) {
            throw new SchemaException(SchemaProblem.TYPE_ERROR, "not a string");
        }
        return Pattern.compile(node.asText());
    }

    public static boolean canDeserialize(JsonNode node) {
        return node != null && (node.isObject() || node.isBoolean());
    }

    static {
        supportedSchemas.add(JsonSchema.DRAFT_4);
        supportedSchemas.add(JsonSchema.DRAFT_6);
        supportedSchemas.add(JsonSchema.DRAFT_7);
        PATTERN_COMPARATOR = new Comparator<Pattern>(){

            @Override
            public int compare(Pattern a, Pattern b) {
                return a.toString().compareTo(b.toString());
            }
        };
    }
}

