/*
 * Decompiled with CFR 0.152.
 */
package io.zerocopy.json.schema;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.zerocopy.json.schema.JsonSchema;
import io.zerocopy.json.schema.format.DateTimeConverter;
import io.zerocopy.json.schema.format.RFC3339Converter;
import java.math.BigDecimal;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class JsonSchemaV7
extends JsonSchema {
    public static final URI URI = DRAFT_7;
    private static final String IPV4 = "(?:(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3})";
    private static final String IPV6 = "(?:[a-fA-F0-9]{0,4}(:[a-fA-F0-9]{0,4}){0,7})";
    private static final String HOSTNAME = "(?:[a-zA-Z0-9][a-zA-Z0-9-]{0,62}(?:\\.[a-zA-Z0-9-]{1,63})+\\.?)";
    private static final String URI_SCHEME = "(?:[^\\s:/?#\\\\{}]+)";
    private static final String URI_PATH_TOKEN = "(?:[^?#\\s\\\\]+)";
    private static final String URI_QUERY_TOKEN = "(?:[^#\\s\\\\]+)";
    private static final String URI_FRAGMENT_TOKEN = "(?:[^\\s\\\\]+)";
    private static final String URI_TEMPLATE_PATH_TOKEN = "(?:\\{[^{}]*\\}|[^?#{}\\s\\\\])";
    private static final String URI_TEMPLATE_QUERY_TOKEN = "(?:\\{[^{}]*\\}|[^#{}\\s\\\\])";
    private static final String URI_TEMPLATE_FRAGMENT_TOKEN = "(?:\\{[^{}]*\\}|[^{}\\s\\\\])";
    private static final String URI_AUTHORITY = "(?:(?:[^\\s@]*@)?((?:(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3})|\\[(?:[a-fA-F0-9]{0,4}(:[a-fA-F0-9]{0,4}){0,7})(?:%25[^]*])?]|(?:[a-zA-Z0-9][a-zA-Z0-9-]{0,62}(?:\\.[a-zA-Z0-9-]{1,63})+\\.?))(?::[0-9]+)?)";
    private static final String JSON_POINTER_PATH_ELEM = "(?:/+(?:[^/~]|(?:~[01]))*)";
    @JsonIgnore
    public boolean numberWithZeroFractionAsInteger = true;
    @JsonIgnore
    public Boolean booleanValidity;
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED})
    public Type[] type;
    public String title;
    public String description;
    public String comment;
    public ArrayNode examples;
    @JsonProperty(value="const")
    public JsonNode _const;
    @JsonProperty(value="default")
    public JsonNode _default;
    @JsonProperty(value="enum")
    public ArrayNode _enum;
    public ArrayNode allOf;
    public ArrayNode anyOf;
    public ArrayNode oneOf;
    public JsonNode not;
    public Integer maxProperties;
    public Integer minProperties;
    public ObjectNode properties;
    public ArrayNode required;
    public Map<Pattern, JsonNode> patternProperties;
    public JsonNode additionalProperties;
    public JsonNode dependencies;
    public JsonNode propertyNames;
    public JsonNode items;
    public JsonNode additionalItems;
    public Integer minItems;
    public Integer maxItems;
    public Boolean uniqueItems;
    public JsonNode contains;
    public Format format;
    public Pattern pattern;
    public Integer minLength;
    public Integer maxLength;
    public String contentMediaType;
    public String contentEncoding;
    public BigDecimal minimum;
    public BigDecimal maximum;
    public BigDecimal exclusiveMinimum;
    public BigDecimal exclusiveMaximum;
    public BigDecimal multipleOf;
    @JsonProperty(value="if")
    public JsonNode _if;
    @JsonProperty(value="then")
    public JsonNode _then;
    @JsonProperty(value="else")
    public JsonNode _else;
    public Boolean readOnly;
    public Boolean writeOnly;

    public JsonSchemaV7 clone() {
        try {
            return (JsonSchemaV7)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static enum Format {
        DATE_TIME("date-time", new RFC3339Converter(RFC3339Converter.Format.DATE_TIME)),
        DATE("date", new RFC3339Converter(RFC3339Converter.Format.DATE)),
        TIME("time", new RFC3339Converter(RFC3339Converter.Format.TIME)),
        URI("uri", Pattern.compile("^(?:[^\\s:/?#\\\\{}]+):(?:(//(?:(?:[^\\s@]*@)?((?:(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3})|\\[(?:[a-fA-F0-9]{0,4}(:[a-fA-F0-9]{0,4}){0,7})(?:%25[^]*])?]|(?:[a-zA-Z0-9][a-zA-Z0-9-]{0,62}(?:\\.[a-zA-Z0-9-]{1,63})+\\.?))(?::[0-9]+)?)(/(?:[^?#\\s\\\\]+)*))?|(?<!//)((?:[^?#\\s\\\\]+)*)?)(\\?(?:[^#\\s\\\\]+)*)?(#(?:[^\\s\\\\]+)*)?$")),
        URI_REFERENCE("uri-reference", Pattern.compile("^(?:(?:[^\\s:/?#\\\\{}]+):(?:(?:(//(?:(?:[^\\s@]*@)?((?:(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3})|\\[(?:[a-fA-F0-9]{0,4}(:[a-fA-F0-9]{0,4}){0,7})(?:%25[^]*])?]|(?:[a-zA-Z0-9][a-zA-Z0-9-]{0,62}(?:\\.[a-zA-Z0-9-]{1,63})+\\.?))(?::[0-9]+)?)(/(?:[^?#\\s\\\\]+)*))?)|(?<!//)((?:[^?#\\s\\\\]+)*)?)|((?:[^?#\\s\\\\]+)*)?)(\\?(?:[^#\\s\\\\]+)*)?(#(?:[^\\s\\\\]+)*)?$")),
        URI_TEMPLATE("uri-template", Pattern.compile("^(?:(?:[^\\s:/?#\\\\{}]+):(?:(?:(//(?:(?:[^\\s@]*@)?((?:(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3})|\\[(?:[a-fA-F0-9]{0,4}(:[a-fA-F0-9]{0,4}){0,7})(?:%25[^]*])?]|(?:[a-zA-Z0-9][a-zA-Z0-9-]{0,62}(?:\\.[a-zA-Z0-9-]{1,63})+\\.?))(?::[0-9]+)?)(/(?:\\{[^{}]*\\}|[^?#{}\\s\\\\])*))?)|(?<!//)((?:\\{[^{}]*\\}|[^?#{}\\s\\\\])*)?)|((?:\\{[^{}]*\\}|[^?#{}\\s\\\\])*)?)(\\?(?:\\{[^{}]*\\}|[^#{}\\s\\\\])*)?(#(?:\\{[^{}]*\\}|[^{}\\s\\\\])*)?$")),
        IRI("iri"),
        IRI_REFERENCE("iri-reference"),
        EMAIL("email", Pattern.compile("^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}?$")),
        IDN_EMAIL("idn-email", Pattern.compile("^[^@]+@[^@]+$")),
        HOSTNAME("hostname", Pattern.compile("^(?:[a-zA-Z0-9][a-zA-Z0-9-]{0,62}(?:\\.[a-zA-Z0-9-]{1,63})+\\.?)$")),
        IDN_HOSTNAME("idn-hostname"),
        IPV4("ipv4", Pattern.compile("^(?:(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3})$")),
        IPV6("ipv6", Pattern.compile("^(?:[a-fA-F0-9]{0,4}(:[a-fA-F0-9]{0,4}){0,7})$")),
        REGEX("regex", Pattern.compile("((?<!\\\\[SZ]).)+")),
        JSON_POINTER("json-pointer", Pattern.compile("^(?:/+(?:[^/~]|(?:~[01]))*)*$")),
        RELATIVE_JSON_POINTER("relative-json-pointer", Pattern.compile("^(0|[1-9][0-9]*)(/(?:(?:[^/~]|(~[01]))+)*)*#?$"));

        @JsonValue
        public final String value;
        public final DateTimeConverter dateTimeConverter;
        public final Pattern pattern;
        private static final Map<String, Format> valueMapping;

        private Format(String value) {
            this.value = value;
            this.dateTimeConverter = null;
            this.pattern = null;
        }

        private Format(String value, DateTimeConverter dateTimeConverter) {
            this.value = value;
            this.dateTimeConverter = dateTimeConverter;
            this.pattern = null;
        }

        private Format(String value, Pattern pattern) {
            this.value = value;
            this.dateTimeConverter = null;
            this.pattern = pattern;
        }

        public static Format forValue(String value) {
            if (value == null) {
                return null;
            }
            Format format = valueMapping.get(value);
            if (format != null) {
                return format;
            }
            throw new IllegalArgumentException();
        }

        static {
            valueMapping = new HashMap<String, Format>();
            for (Format format : Format.values()) {
                valueMapping.put(format.value, format);
            }
        }
    }

    public static enum Type {
        OBJECT("object", JsonNodeType.OBJECT),
        ARRAY("array", JsonNodeType.ARRAY),
        STRING("string", JsonNodeType.STRING),
        NUMBER("number", JsonNodeType.NUMBER),
        INTEGER("integer", JsonNodeType.NUMBER, NUMBER),
        BOOLEAN("boolean", JsonNodeType.BOOLEAN),
        NULL("null", JsonNodeType.NULL);

        @JsonValue
        public final String value;
        public final JsonNodeType nodeType;
        public final Type superType;
        private static final Map<String, Type> valueMapping;

        private Type(String value, JsonNodeType nodeType, Type superType) {
            this.value = value;
            this.nodeType = nodeType;
            this.superType = superType;
        }

        private Type(String value, JsonNodeType nodeType) {
            this(value, nodeType, null);
        }

        public static Type forValue(String value) {
            if (value == null) {
                return null;
            }
            Type type = valueMapping.get(value);
            if (type != null) {
                return type;
            }
            throw new IllegalArgumentException();
        }

        static {
            valueMapping = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                valueMapping.put(type.value, type);
            }
        }
    }

    public static enum Rule {
        REF("ref"),
        TYPE("type"),
        MAX_PROPERTIES("maxProperties"),
        MIN_PROPERTIES("minProperties"),
        DEPENDENCY("dependency"),
        PATTERN_PROPERTIES("patternProperties"),
        PROPERTY_NAMES("propertyNames"),
        REQUIRED("required"),
        ADDITIONAL_PROPERTIES("additionalProperties"),
        MIN_ITEMS("minItems"),
        MAX_ITEMS("maxItems"),
        ITEMS("items"),
        NOT("not"),
        UNIQUE_ITEMS("uniqueItems"),
        CONTENT_ENCODING("contentEncoding"),
        CONTENT_MEDIA_TYPE("contentMediaType"),
        FORMAT("format"),
        PATTERN("pattern"),
        MIN_LENGTH("minLength"),
        MAX_LENGTH("maxLength"),
        MINIMUM("minimum"),
        EXCLUSIVE_MINIMUM("exclusiveMinimum"),
        MAXIMUM("maximum"),
        EXCLUSIVE_MAXIMUM("exclusiveMaximum"),
        MULTIPLE_OF("multipleOf"),
        CONST("const"),
        ENUM("enum"),
        ANY_OF("anyOf"),
        ONE_OF("oneOf"),
        ALL_OF("allOf"),
        BOOLEAN_SCHEMA("booleanSchema");

        public final String value;

        private Rule(String value) {
            this.value = value;
        }
    }
}

