/*
 * Decompiled with CFR 0.152.
 */
package io.zerocopy.json.schema;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.zerocopy.json.schema.SchemaException;
import io.zerocopy.json.schema.SchemaProblem;
import io.zerocopy.json.schema.document.SchemaReference;
import io.zerocopy.json.schema.pointer.JsonPointerUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class SchemaUtils {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final Comparator<Pattern> PATTERN_COMPARATOR = new Comparator<Pattern>(){

        @Override
        public int compare(Pattern a, Pattern b) {
            return a.pattern().compareTo(b.pattern());
        }
    };

    public static JsonNode resolveRelativeRef(JsonNode rootNode, JsonNode referringNode, String ref) {
        try {
            ref = URLDecoder.decode(ref, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (ref.length() > 0 && ref.charAt(0) == '#') {
            return JsonPointerUtils.resolvePointer(rootNode, ref.substring(1));
        }
        return JsonPointerUtils.resolvePointer(referringNode, ref);
    }

    public static SchemaReference resolveRelativeRefPath(List<String> pathOut, JsonNode rootNode, JsonNode referringNode, String ref) {
        JsonNode resolvedNode;
        String schemaPointer;
        try {
            ref = URLDecoder.decode(ref, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (ref.length() > 0 && ref.charAt(0) == '#') {
            schemaPointer = ref.substring(1);
            resolvedNode = JsonPointerUtils.resolvePointerPath(pathOut, rootNode, schemaPointer);
        } else {
            schemaPointer = ref;
            resolvedNode = JsonPointerUtils.resolvePointerPath(pathOut, referringNode, schemaPointer);
        }
        if (resolvedNode != null) {
            return new SchemaReference(rootNode, JsonPointer.compile((String)schemaPointer), resolvedNode);
        }
        return null;
    }

    public static void visitAllNodes(JsonNode node, NodeVisitor visitor) {
        LinkedList<String> path = new LinkedList<String>();
        SchemaUtils.visitAllNodes(path, node, visitor);
    }

    public static void visitAllNodes(LinkedList<String> path, JsonNode node, NodeVisitor visitor) {
        visitor.push(path, node);
        if (node.isObject()) {
            Iterator fieldIterator = node.fields();
            while (fieldIterator.hasNext()) {
                Map.Entry field = (Map.Entry)fieldIterator.next();
                JsonNode childNode = (JsonNode)field.getValue();
                if (!node.isObject() && !node.isArray()) continue;
                path.addLast((String)field.getKey());
                SchemaUtils.visitAllNodes(path, childNode, visitor);
                path.removeLast();
            }
        } else if (node.isArray()) {
            int index = 0;
            Iterator fieldIterator = node.elements();
            while (fieldIterator.hasNext()) {
                JsonNode childNode = (JsonNode)fieldIterator.next();
                if (!node.isObject() && !node.isArray()) continue;
                path.addLast(Integer.toString(index));
                SchemaUtils.visitAllNodes(path, childNode, visitor);
                path.removeLast();
            }
        }
        visitor.pop(path, node);
    }

    public static void findAllRefsInSchema(final JsonNode rootNode, final JsonNode schemaNode, final Set<String> refsOut) {
        SchemaUtils.visitAllNodes(schemaNode, new NodeVisitor(){

            @Override
            public void push(LinkedList<String> path, JsonNode node) {
                boolean newRef;
                JsonNode ref = node.get("$ref");
                if (ref != null && (newRef = refsOut.add(ref.asText()))) {
                    JsonNode referencedNode = SchemaUtils.resolveRelativeRef(rootNode, schemaNode, ref.asText());
                    if (referencedNode == null) {
                        throw new SchemaException(SchemaProblem.INVALID_REF, ref.asText());
                    }
                    SchemaUtils.findAllRefsInSchema(rootNode, referencedNode, refsOut);
                }
            }

            @Override
            public void pop(LinkedList<String> path, JsonNode node) {
            }
        });
    }

    static {
        OBJECT_MAPPER.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
    }

    public static interface NodeVisitor {
        public void push(LinkedList<String> var1, JsonNode var2);

        public void pop(LinkedList<String> var1, JsonNode var2);
    }
}

