/*
 * Decompiled with CFR 0.152.
 */
package io.zerocopy.json.schema.context;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.zerocopy.json.schema.JsonSchema;
import io.zerocopy.json.schema.JsonSchemaDeserializer;
import io.zerocopy.json.schema.JsonSchemaV7;
import io.zerocopy.json.schema.SchemaException;
import io.zerocopy.json.schema.SchemaProblem;
import io.zerocopy.json.schema.SchemaUtils;
import io.zerocopy.json.schema.context.SchemaResolutionNode;
import io.zerocopy.json.schema.context.SchemaResolutionSubContext;
import io.zerocopy.json.schema.document.SchemaReference;
import io.zerocopy.json.schema.loader.DocumentLoader;
import io.zerocopy.json.schema.pointer.JsonPointerUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class SchemaResolutionContext {
    private URI defaultSchemaVersion = JsonSchema.LATEST;
    private DocumentLoader documentLoader;
    private LinkedList<SchemaResolutionSubContext> subContexts = new LinkedList();
    private final Map<String, SchemaReference> schemaCache = new ConcurrentHashMap<String, SchemaReference>();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public URI getDefaultSchemaVersion() {
        return this.defaultSchemaVersion;
    }

    public void setDefaultSchemaVersion(URI defaultSchemaVersion) {
        this.defaultSchemaVersion = defaultSchemaVersion;
    }

    public DocumentLoader getDocumentLoader() {
        return this.documentLoader;
    }

    public void setDocumentLoader(DocumentLoader documentLoader) {
        this.documentLoader = documentLoader;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public JsonSchemaV7 pushSchemaNode(JsonNode rootNode, String path, JsonNode node, boolean requireSchema) {
        SchemaResolutionSubContext schemaResolutionSubContext;
        boolean isSchemaRoot;
        JsonSchemaV7 schema;
        String id = null;
        URI schemaVersion = null;
        JsonSchemaV7 jsonSchemaV7 = schema = requireSchema || JsonSchemaDeserializer.canDeserialize(node) ? this.mapSchema(node) : null;
        if (schema != null) {
            id = schema.id;
            schemaVersion = schema.schema;
        }
        boolean bl = isSchemaRoot = id != null && URI.create(id).getRawAuthority() != null;
        if (isSchemaRoot || this.subContexts.isEmpty()) {
            schemaResolutionSubContext = new SchemaResolutionSubContext();
            this.subContexts.addLast(schemaResolutionSubContext);
        } else {
            schemaResolutionSubContext = this.subContexts.getLast();
        }
        SchemaResolutionNode schemaResolutionNode = new SchemaResolutionNode();
        schemaResolutionNode.rootNode = rootNode;
        schemaResolutionNode.path = JsonPointer.compile((String)path);
        schemaResolutionNode.node = node;
        schemaResolutionNode.id = id;
        schemaResolutionNode.schemaVersion = schemaVersion;
        schemaResolutionSubContext.nodes.addLast(schemaResolutionNode);
        return schema;
    }

    public JsonSchemaV7 pushSchemaNode(JsonNode rootNode, List<String> path, JsonNode node, boolean requireSchema) {
        StringBuilder pointer = new StringBuilder();
        JsonPointerUtils.implode(pointer, path);
        return this.pushSchemaNode(rootNode, pointer.toString(), node, requireSchema);
    }

    public JsonSchemaV7 pushSchemaNode(JsonNode rootNode, JsonPointer jsonPointer, JsonNode node, boolean requireSchema) {
        return this.pushSchemaNode(rootNode, jsonPointer.toString(), node, requireSchema);
    }

    public JsonSchemaV7 pushSchemaNode(SchemaReference schemaReference, boolean requireSchema) {
        return this.pushSchemaNode(schemaReference.getRoot(), schemaReference.getSchemaPointer(), schemaReference.getSchema(), requireSchema);
    }

    public void popSchemaNode(JsonNode rootNode, String path, JsonNode node) {
        SchemaResolutionSubContext schemaResolutionSubContext = this.subContexts.getLast();
        if (schemaResolutionSubContext.nodes.getLast().node == node) {
            schemaResolutionSubContext.nodes.removeLast();
            if (schemaResolutionSubContext.nodes.isEmpty()) {
                this.subContexts.removeLast();
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public void popSchemaNode(JsonNode rootNode, List<String> path, JsonNode node) {
        StringBuilder pointer = new StringBuilder();
        JsonPointerUtils.implode(pointer, path);
        this.popSchemaNode(rootNode, pointer.toString(), node);
    }

    public void popSchemaNode(JsonNode rootNode, JsonPointer jsonPointer, JsonNode node) {
        this.popSchemaNode(rootNode, jsonPointer.toString(), node);
    }

    public void popSchemaNode(SchemaReference schemaReference) {
        this.popSchemaNode(schemaReference.getRoot(), schemaReference.getSchemaPointer(), schemaReference.getSchema());
    }

    public JsonSchemaV7 pushSchemaReference(SchemaReference schemaReference) {
        return this.pushSchemaNode(schemaReference, true);
    }

    public void popSchemaReference(SchemaReference schemaReference) {
        this.popSchemaNode(schemaReference);
    }

    public URI getUpperId() {
        if (!this.subContexts.isEmpty()) {
            return this.subContexts.getLast().getUpperId();
        }
        return null;
    }

    public URI getFullId() {
        if (!this.subContexts.isEmpty()) {
            return this.subContexts.getLast().getFullId();
        }
        return null;
    }

    public void clear() {
        this.subContexts.clear();
    }

    public JsonSchemaV7 mapSchema(JsonNode node) {
        return JsonSchemaDeserializer.mapSchema(this.getDefaultSchemaVersion(), node);
    }

    private SchemaResolutionContext createResolutionContext() {
        SchemaResolutionContext resolutionContext = new SchemaResolutionContext();
        resolutionContext.setDefaultSchemaVersion(this.getDefaultSchemaVersion());
        return resolutionContext;
    }

    public SchemaReference resolveSchema(JsonNode rootNode, JsonNode schemaNode, String ref, List<String> refPathOut, boolean noRecurse) throws IOException {
        URI schemaLocation;
        SchemaReference referencedSchema = null;
        URI baseUri = this.getUpperId();
        try {
            URI childUri = URI.create(ref);
            schemaLocation = !ref.startsWith("#") ? (baseUri != null ? baseUri.resolve(childUri).normalize() : childUri) : childUri;
        }
        catch (IllegalArgumentException e) {
            throw new SchemaException(SchemaProblem.INVALID_REF, "invalid ref", e);
        }
        if (schemaLocation.getAuthority() != null) {
            referencedSchema = this.loadRemoteSchema(rootNode, schemaLocation);
        } else {
            if (noRecurse && !this.subContexts.isEmpty()) {
                JsonPointer jsonPointer = JsonPointer.compile((String)schemaLocation.getRawFragment());
                for (SchemaResolutionNode node : this.subContexts.getLast().nodes) {
                    if (node.rootNode != rootNode || !node.path.equals((Object)jsonPointer)) continue;
                    throw new SchemaException(SchemaProblem.RECURSION, "recurring ref: " + ref);
                }
            }
            referencedSchema = SchemaUtils.resolveRelativeRefPath(refPathOut, rootNode, schemaNode, "#" + schemaLocation.getRawFragment());
        }
        return referencedSchema;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SchemaReference loadRemoteSchema(final JsonNode rootNode, URI schemaLocation) throws IOException {
        JsonNode referencedRootNode = null;
        JsonPointer referencedSchemaPointer = null;
        JsonNode referencedNode = null;
        JsonNode referencedSchema = null;
        final String cacheKey = schemaLocation.normalize().toASCIIString();
        SchemaReference result = this.schemaCache.get(cacheKey);
        if (result != null) return result;
        final SchemaResolutionContext resolutionContext = this.createResolutionContext();
        final ArrayList<String> foundSchemaPath = new ArrayList<String>();
        final AtomicReference foundSchema = new AtomicReference();
        SchemaUtils.visitAllNodes(rootNode, new SchemaUtils.NodeVisitor(){

            @Override
            public void push(LinkedList<String> path, JsonNode node) {
                resolutionContext.pushSchemaNode(rootNode, path, node, false);
                URI fullId = resolutionContext.getFullId();
                if (fullId != null && fullId.toASCIIString().equals(cacheKey)) {
                    if (!foundSchema.compareAndSet(null, node)) {
                        if (foundSchema.get() != node) {
                            throw new SchemaException(SchemaProblem.DUPLICATE_ID, "multiple nodes with id: " + cacheKey);
                        }
                    } else {
                        foundSchemaPath.addAll(path);
                    }
                }
            }

            @Override
            public void pop(LinkedList<String> path, JsonNode node) {
                resolutionContext.popSchemaNode(rootNode, path, node);
            }
        });
        referencedNode = (JsonNode)foundSchema.get();
        if (referencedNode != null) {
            referencedRootNode = rootNode;
            referencedSchemaPointer = JsonPointer.compile((String)JsonPointerUtils.implode(foundSchemaPath));
        }
        if (referencedNode == null) {
            if (this.getDocumentLoader() == null) throw new IOException("Failed to load schema, no schema loader installed: " + schemaLocation);
            URL schemaUrl = schemaLocation.toURL();
            String ref = schemaUrl.getRef();
            try (InputStream inputStream = this.getDocumentLoader().openURL(schemaUrl);){
                referencedRootNode = resolutionContext.getObjectMapper().readTree(inputStream);
                if (referencedRootNode != null) {
                    if (ref != null) {
                        referencedSchemaPointer = JsonPointer.compile((String)URLDecoder.decode(ref, "UTF-8"));
                        referencedNode = referencedRootNode.at(referencedSchemaPointer);
                        if (referencedNode == null) {
                            throw new IOException("Failed to resolve ref: " + ref);
                        }
                    } else {
                        referencedSchemaPointer = JsonPointer.compile((String)"");
                        referencedNode = referencedRootNode;
                    }
                }
            }
            catch (Exception e) {
                throw new IOException("Failed to load schema: " + schemaLocation, e);
            }
        }
        if (referencedNode != null) {
            referencedSchema = referencedNode;
        }
        if (referencedSchema == null) {
            throw new IOException("No such schema: " + schemaLocation);
        }
        result = new SchemaReference(referencedRootNode, referencedSchemaPointer, referencedSchema);
        this.schemaCache.put(cacheKey, result);
        return result;
    }
}

