/*
 * Decompiled with CFR 0.152.
 */
package io.zerocopy.json.schema.document;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class SchemaDocument {
    private JsonNode root;
    private Set<JsonPointer> schemaParents = new LinkedHashSet<JsonPointer>();

    public SchemaDocument(JsonNode root) {
        this.root = root;
    }

    public SchemaDocument(JsonNode root, Collection<JsonPointer> schemaParents) {
        this.root = root;
        this.schemaParents.addAll(schemaParents);
    }

    public SchemaDocument(JsonNode root, JsonPointer ... schemaParents) {
        this(root, Arrays.asList(schemaParents));
    }

    public SchemaDocument() {
        this(null);
    }

    public JsonNode getRoot() {
        return this.root;
    }

    public void setRoot(JsonNode root) {
        this.root = root;
    }

    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    public Set<JsonPointer> getSchemaParents() {
        return this.schemaParents;
    }

    public void setSchemaParents(Set<JsonPointer> schemaParents) {
        this.schemaParents = schemaParents;
    }

    @JsonIgnore
    public Map<JsonPointer, JsonNode> getSchemaParentMap() {
        final Set<Object> schemaParents = !this.schemaParents.isEmpty() ? this.schemaParents : Collections.emptySet();
        return new AbstractMap<JsonPointer, JsonNode>(){

            @Override
            public Set<Map.Entry<JsonPointer, JsonNode>> entrySet() {
                return new AbstractSet<Map.Entry<JsonPointer, JsonNode>>(){

                    @Override
                    public Iterator<Map.Entry<JsonPointer, JsonNode>> iterator() {
                        return new Iterator<Map.Entry<JsonPointer, JsonNode>>(){
                            Iterator<JsonPointer> iterator;
                            {
                                this.iterator = schemaParents.iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.iterator.hasNext();
                            }

                            @Override
                            public Map.Entry<JsonPointer, JsonNode> next() {
                                final JsonPointer jsonPointer = this.iterator.next();
                                final JsonNode jsonNode = SchemaDocument.this.root.at(jsonPointer);
                                return new Map.Entry<JsonPointer, JsonNode>(){

                                    @Override
                                    public JsonPointer getKey() {
                                        return jsonPointer;
                                    }

                                    @Override
                                    public JsonNode getValue() {
                                        return jsonNode;
                                    }

                                    @Override
                                    public JsonNode setValue(JsonNode jsonNode2) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return SchemaDocument.this.schemaParents.size();
                    }
                };
            }
        };
    }
}

