/*
 * Decompiled with CFR 0.152.
 */
package io.zerocopy.json.schema.document;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;

public class SchemaReference {
    private static final boolean STRICT_NODE_VALIDATION = false;
    private JsonNode root;
    private JsonPointer schemaPointer;
    private JsonNode node;

    public SchemaReference(JsonNode root, JsonPointer schemaPointer, JsonNode node) {
        if (root == null || schemaPointer == null) {
            throw new IllegalArgumentException();
        }
        if (false & node != null) {
            JsonNode resolvedNode = root.at(schemaPointer);
            if (resolvedNode.isMissingNode()) {
                resolvedNode = null;
            }
            if (node != resolvedNode) {
                throw new IllegalArgumentException();
            }
        }
        this.root = root;
        this.schemaPointer = schemaPointer;
        this.node = node;
    }

    public SchemaReference(JsonNode root, JsonPointer schemaPointer) {
        this(root, schemaPointer, null);
    }

    public SchemaReference(JsonNode root, String schemaPointer) {
        this(root, JsonPointer.compile((String)schemaPointer), null);
    }

    public SchemaReference(JsonNode root) {
        this(root, JsonPointer.compile((String)""), null);
    }

    public JsonNode getRoot() {
        return this.root;
    }

    public void setRoot(JsonNode root) {
        this.root = root;
    }

    public JsonPointer getSchemaPointer() {
        return this.schemaPointer;
    }

    public void setSchemaPointer(JsonPointer schemaPointer) {
        this.schemaPointer = schemaPointer;
    }

    @JsonIgnore
    public JsonNode getSchema() {
        if (this.node == null) {
            this.node = this.schemaPointer != null ? this.root.at(this.schemaPointer) : this.root;
        }
        return !this.node.isMissingNode() ? this.node : null;
    }
}

