/*
 * Decompiled with CFR 0.152.
 */
package io.zerocopy.json.schema.format;

import io.zerocopy.json.schema.format.AbstractDateTimeConverter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RFC3339Converter
extends AbstractDateTimeConverter {
    protected final Format format;

    public RFC3339Converter(Format format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    @Override
    public Date parse(String source) {
        return RFC3339Converter.parseRFC3339Date(source, this.format);
    }

    @Override
    public void format(Appendable out, Date date, int offset) throws IOException {
        RFC3339Converter.printRFC3339Date(out, date, this.format, offset);
    }

    public static Date parseRFC3339Date(String source, Format format) {
        if (format == null) {
            throw new IllegalArgumentException();
        }
        Matcher matcher = format.pattern.matcher(source);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("not a " + format.name() + " string");
        }
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int leapSeconds = 0;
        int millisecond = 0;
        String offsetSign = null;
        int offsetHours = 0;
        int offsetMinutes = 0;
        if (format == Format.DATE) {
            year = RFC3339Converter.intGroup(matcher, 1);
            month = RFC3339Converter.intGroup(matcher, 2);
            day = RFC3339Converter.intGroup(matcher, 3);
        }
        if (format == Format.DATE_TIME) {
            year = RFC3339Converter.intGroup(matcher, 1);
            month = RFC3339Converter.intGroup(matcher, 2);
            day = RFC3339Converter.intGroup(matcher, 3);
            hour = RFC3339Converter.intGroup(matcher, 4, 0, 23);
            minute = RFC3339Converter.intGroup(matcher, 5, 0, 59);
            second = RFC3339Converter.intGroup(matcher, 6, 0, 60);
            millisecond = RFC3339Converter.fractGroup(matcher, 7, 3);
            offsetSign = matcher.group(8);
            offsetHours = RFC3339Converter.intGroup(matcher, 9, 0, 23);
            offsetMinutes = RFC3339Converter.intGroup(matcher, 10, 0, 59);
        }
        if (format == Format.TIME) {
            hour = RFC3339Converter.intGroup(matcher, 1, 0, 23);
            minute = RFC3339Converter.intGroup(matcher, 2, 0, 59);
            second = RFC3339Converter.intGroup(matcher, 3, 0, 60);
            millisecond = RFC3339Converter.fractGroup(matcher, 4, 3);
            offsetSign = matcher.group(5);
            offsetHours = RFC3339Converter.intGroup(matcher, 6, 0, 23);
            offsetMinutes = RFC3339Converter.intGroup(matcher, 7, 0, 59);
        }
        if (second > 59) {
            leapSeconds = second - 59;
            second -= leapSeconds;
        }
        int zoneOffsetMilliseconds = 0;
        if (offsetSign != null) {
            zoneOffsetMilliseconds = (int)((long)zoneOffsetMilliseconds + 3600000L * (long)offsetHours);
            zoneOffsetMilliseconds = (int)((long)zoneOffsetMilliseconds + 60000L * (long)offsetMinutes);
            if (offsetSign.equals("-")) {
                zoneOffsetMilliseconds = -zoneOffsetMilliseconds;
            }
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setLenient(false);
        if (format == Format.DATE || format == Format.DATE_TIME) {
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
        }
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        calendar.set(15, zoneOffsetMilliseconds);
        if (leapSeconds > 0) {
            if (calendar.getTimeInMillis() % 86400000L / 1000L != 86399L) {
                throw new IllegalArgumentException("invalid time for leap seconds");
            }
            calendar.add(13, leapSeconds);
        }
        return calendar.getTime();
    }

    public static void printRFC3339Date(Appendable out, Date date, Format format, int offset) throws IOException {
        if (offset % 60000 != 0) {
            throw new IllegalArgumentException("zoneOffset must be a multiple of 60000 ms (minutes)");
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(new Date(date.getTime() + (long)offset));
        calendar.set(15, offset);
        if (format == Format.DATE || format == Format.DATE_TIME) {
            RFC3339Converter.padInt(out, calendar.get(1), 4);
            out.append('-');
            RFC3339Converter.padInt(out, calendar.get(2) + 1, 2);
            out.append('-');
            RFC3339Converter.padInt(out, calendar.get(5), 2);
        }
        if (format == Format.DATE_TIME) {
            out.append('T');
        }
        if (format == Format.TIME || format == Format.DATE_TIME) {
            RFC3339Converter.padInt(out, calendar.get(11), 2);
            out.append(':');
            RFC3339Converter.padInt(out, calendar.get(12), 2);
            out.append(':');
            RFC3339Converter.padInt(out, calendar.get(13), 2);
            out.append('.');
            RFC3339Converter.padInt(out, calendar.get(14), 3);
            if (offset != 0) {
                int offsetUnsigned;
                char offsetSign;
                if (offset >= 0) {
                    offsetSign = '+';
                    offsetUnsigned = offset;
                } else {
                    offsetSign = '-';
                    offsetUnsigned = -offset;
                }
                out.append(offsetSign);
                RFC3339Converter.padInt(out, offsetUnsigned / 3600000, 2);
                out.append(':');
                RFC3339Converter.padInt(out, offsetUnsigned % 3600000 / 60000, 2);
            } else {
                out.append('Z');
            }
        }
    }

    private static int intGroup(Matcher matcher, int group) {
        String groupValue = matcher.group(group);
        if (groupValue != null) {
            return Integer.parseInt(groupValue, 10);
        }
        return 0;
    }

    private static int intGroup(Matcher matcher, int group, int min, int max) {
        int value = RFC3339Converter.intGroup(matcher, group);
        if (value < min || value > max) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    private static int fractGroup(Matcher matcher, int group, int negPow10) {
        String groupValue = matcher.group(group);
        if (groupValue != null) {
            if (groupValue.length() > negPow10) {
                groupValue = groupValue.substring(0, negPow10);
            }
            return Integer.parseInt(groupValue, 10);
        }
        return 0;
    }

    private static void padInt(Appendable out, int value, int places) throws IOException {
        String str = Integer.toString(value);
        while (places-- > str.length()) {
            out.append('0');
        }
        out.append(str);
    }

    public static enum Format {
        DATE("([0-9]+)-([0-9]{2})-([0-9]{2})"),
        TIME("([0-9]{2}):([0-9]{2})(?::([0-9]{2})(?:.([0-9]{1,9}))?)?(?:[Zz]|([+-])([0-9]{2}):([0-9]{2}))"),
        DATE_TIME(Format.DATE.expr + "[Tt]" + Format.TIME.expr);

        public final String expr;
        public final Pattern pattern;

        private Format(String expr) {
            this.expr = expr;
            this.pattern = Pattern.compile("^" + expr + "$");
        }
    }
}

