/*
 * Decompiled with CFR 0.152.
 */
package io.zerocopy.json.schema.pointer;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JsonPointerUtils {
    public static JsonNode resolvePointer(JsonNode node, String jsonPointer) {
        JsonNode current = node;
        if (!jsonPointer.isEmpty()) {
            int start = 0;
            do {
                int end;
                if ((end = jsonPointer.indexOf(47, start)) == start) {
                    start = ++end;
                    continue;
                }
                if (end == -1) {
                    end = jsonPointer.length();
                }
                String refSegment = JsonPointerUtils.unescapePointerSegment(jsonPointer.substring(start, end));
                start = end + 1;
                if (current == null) {
                    return null;
                }
                current = JsonPointerUtils.resolvePointerSegment(current, refSegment);
            } while (start < jsonPointer.length());
        }
        return current;
    }

    public static JsonNode resolvePointerPath(List<String> pathOut, JsonNode node, String jsonPointer) {
        JsonNode current = node;
        pathOut.clear();
        if (!jsonPointer.isEmpty()) {
            int start = 0;
            do {
                int end;
                if ((end = jsonPointer.indexOf(47, start)) == start) {
                    start = ++end;
                    continue;
                }
                if (end == -1) {
                    end = jsonPointer.length();
                }
                String refSegment = JsonPointerUtils.unescapePointerSegment(jsonPointer.substring(start, end));
                start = end + 1;
                if (current == null) {
                    return null;
                }
                current = JsonPointerUtils.resolvePointerSegment(current, refSegment);
                pathOut.add(refSegment);
            } while (start < jsonPointer.length());
        }
        return current;
    }

    public static void split(List<String> pathOut, String jsonPointer) {
        pathOut.clear();
        if (!jsonPointer.isEmpty()) {
            int start = 0;
            do {
                int end;
                if ((end = jsonPointer.indexOf(47, start)) == start) {
                    start = ++end;
                    continue;
                }
                if (end == -1) {
                    end = jsonPointer.length();
                }
                String refSegment = JsonPointerUtils.unescapePointerSegment(jsonPointer.substring(start, end));
                start = end + 1;
                pathOut.add(refSegment);
            } while (start < jsonPointer.length());
        }
    }

    public static List<String> split(String jsonPointer) {
        ArrayList<String> pathElems = new ArrayList<String>();
        JsonPointerUtils.split(pathElems, jsonPointer);
        return pathElems;
    }

    public static void implode(Appendable pointerOut, List<String> path) throws IOException {
        boolean i = false;
        for (String pathElem : path) {
            pointerOut.append('/');
            pathElem = JsonPointerUtils.escapePointerSegment(pathElem);
            pointerOut.append(pathElem);
        }
    }

    public static void implode(StringBuilder pointerOut, List<String> path) {
        try {
            JsonPointerUtils.implode((Appendable)pointerOut, path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String implode(List<String> path) {
        StringBuilder pointer = new StringBuilder();
        JsonPointerUtils.implode(pointer, path);
        return pointer.toString();
    }

    private static JsonNode resolvePointerSegment(JsonNode node, String pointerSegment) {
        if (node.isArray()) {
            try {
                int index = Integer.parseInt(pointerSegment, 10);
                return node.get(index);
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return node.get(pointerSegment);
    }

    public static String unescapePointerSegment(String pointerSegment) {
        pointerSegment = JsonPointerUtils.replaceAll(pointerSegment, "~1", "/");
        pointerSegment = JsonPointerUtils.replaceAll(pointerSegment, "~0", "~");
        return pointerSegment;
    }

    public static String escapePointerSegment(String pointerSegment) {
        pointerSegment = JsonPointerUtils.replaceAll(pointerSegment, "~", "~0");
        pointerSegment = JsonPointerUtils.replaceAll(pointerSegment, "/", "~1");
        return pointerSegment;
    }

    private static String replaceAll(String string, String substring, CharSequence replacement) {
        int start;
        StringBuilder newString = null;
        int end = 0;
        while ((start = string.indexOf(substring, end)) >= 0) {
            if (newString == null) {
                newString = new StringBuilder();
            }
            newString.append(string, end, start);
            newString.append(replacement);
            end = start + substring.length();
        }
        if (newString != null && end < string.length()) {
            newString.append(string, end, string.length());
        }
        return newString != null ? newString.toString() : string;
    }

    private JsonPointerUtils() {
    }
}

