/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.dependencies.elasticsearch;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.spark.api.java.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Serializable;
import scala.Tuple2;
import zipkin2.DependencyLink;
import zipkin2.codec.SpanBytesDecoder;
import zipkin2.dependencies.elasticsearch.ElasticsearchDependenciesJob;
import zipkin2.internal.DependencyLinker;

final class TraceIdAndJsonToDependencyLinks
implements Serializable,
Function<Iterable<Tuple2<String, String>>, Iterable<DependencyLink>> {
    private static final long serialVersionUID = 0L;
    private static final Logger log = LoggerFactory.getLogger(TraceIdAndJsonToDependencyLinks.class);
    @Nullable
    final Runnable logInitializer;
    final SpanBytesDecoder decoder;

    TraceIdAndJsonToDependencyLinks(Runnable logInitializer, SpanBytesDecoder decoder) {
        this.logInitializer = logInitializer;
        this.decoder = decoder;
    }

    public Iterable<DependencyLink> call(Iterable<Tuple2<String, String>> traceIdJson) {
        if (this.logInitializer != null) {
            this.logInitializer.run();
        }
        ArrayList sameTraceId = new ArrayList();
        for (Tuple2<String, String> row : traceIdJson) {
            try {
                this.decoder.decode(((String)row._2).getBytes(ElasticsearchDependenciesJob.UTF_8), sameTraceId);
            }
            catch (Exception e) {
                log.warn("Unable to decode span from traces where trace_id=" + (String)row._1, (Throwable)e);
            }
        }
        DependencyLinker linker = new DependencyLinker();
        linker.putTrace(sameTraceId);
        return linker.link();
    }
}

