/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.stackdriver.zipkin;

import com.google.devtools.cloudtrace.v2.Span;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import zipkin2.Span;
import zipkin2.reporter.BytesEncoder;
import zipkin2.reporter.Encoding;
import zipkin2.translation.stackdriver.SpanTranslator;

public enum StackdriverEncoder implements BytesEncoder<Span>
{
    V2{

        public Encoding encoding() {
            return Encoding.PROTO3;
        }

        public int sizeInBytes(Span input) {
            return 32 + this.translate(input).getSerializedSize();
        }

        public byte[] encode(Span span) {
            int i;
            com.google.devtools.cloudtrace.v2.Span translated = this.translate(span);
            byte[] result = new byte[32 + translated.getSerializedSize()];
            String traceId = span.traceId();
            if (traceId.length() == 16) {
                for (i = 0; i < 16; ++i) {
                    result[i] = 48;
                }
                for (i = 0; i < 16; ++i) {
                    result[i + 16] = (byte)traceId.charAt(i);
                }
            } else {
                for (i = 0; i < 32; ++i) {
                    result[i] = (byte)traceId.charAt(i);
                }
            }
            CodedOutputStream output = CodedOutputStream.newInstance((byte[])result, (int)32, (int)(result.length - 32));
            try {
                translated.writeTo(output);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            return result;
        }

        com.google.devtools.cloudtrace.v2.Span translate(Span span) {
            return SpanTranslator.translate((Span.Builder)com.google.devtools.cloudtrace.v2.Span.newBuilder(), (Span)span).build();
        }
    };

}

