/*
 * Decompiled with CFR 0.152.
 */
package zipkin.module.storage.stackdriver;

import com.google.auth.Credentials;
import com.google.auth.RequestMetadataCallback;
import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.SimpleDecoratingClient;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestHeaders;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;

class CredentialsDecoratingClient
extends SimpleDecoratingClient<HttpRequest, HttpResponse>
implements AutoCloseable {
    final Credentials credentials;
    final ExecutorService executor;

    static Function<Client<HttpRequest, HttpResponse>, Client<HttpRequest, HttpResponse>> newDecorator(Credentials credentials) {
        return client -> new CredentialsDecoratingClient((Client<HttpRequest, HttpResponse>)client, credentials);
    }

    private CredentialsDecoratingClient(Client<HttpRequest, HttpResponse> delegate, Credentials credentials) {
        super(delegate);
        this.credentials = credentials;
        this.executor = Executors.newSingleThreadExecutor();
    }

    public HttpResponse execute(final ClientRequestContext ctx, final HttpRequest req) {
        URI uri;
        try {
            uri = new URI("https", req.authority(), req.path(), null, null);
        }
        catch (URISyntaxException e) {
            return HttpResponse.ofFailure((Throwable)e);
        }
        final CompletableFuture responseFuture = new CompletableFuture();
        this.credentials.getRequestMetadata(uri, (Executor)this.executor, new RequestMetadataCallback(){

            public void onSuccess(Map<String, List<String>> map) {
                HttpRequest newReq = req;
                if (map != null) {
                    newReq = HttpRequest.of((HttpRequest)req, (RequestHeaders)req.headers().withMutations(headers -> {
                        for (Map.Entry entry : map.entrySet()) {
                            headers.add((CharSequence)HttpHeaderNames.of((CharSequence)((CharSequence)entry.getKey())), (Iterable)entry.getValue());
                        }
                    }));
                }
                try {
                    responseFuture.complete((HttpResponse)((Client)CredentialsDecoratingClient.this.delegate()).execute(ctx, (Request)newReq));
                }
                catch (Exception e) {
                    responseFuture.completeExceptionally(e);
                }
            }

            public void onFailure(Throwable throwable) {
                responseFuture.completeExceptionally(throwable);
            }
        });
        return HttpResponse.from(responseFuture);
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }
}

