/*
 * Decompiled with CFR 0.152.
 */
package zipkin.module.storage.stackdriver;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptionValue;
import com.linecorp.armeria.client.ClientOptionsBuilder;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.logging.LoggingClientBuilder;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.logging.LogLevel;
import io.netty.handler.ssl.OpenSsl;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import zipkin.module.storage.stackdriver.CredentialsDecoratingClient;
import zipkin.module.storage.stackdriver.ZipkinStackdriverStorageProperties;
import zipkin2.Call;
import zipkin2.storage.StorageComponent;
import zipkin2.storage.stackdriver.StackdriverStorage;

@Configuration
@EnableConfigurationProperties(value={ZipkinStackdriverStorageProperties.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="stackdriver")
@ConditionalOnMissingBean(value={StorageComponent.class})
public class ZipkinStackdriverStorageModule {
    @Autowired
    ZipkinStackdriverStorageProperties storageProperties;

    @Bean
    @ConditionalOnMissingBean(value={Credentials.class})
    Credentials googleCredentials() throws IOException {
        return GoogleCredentials.getApplicationDefault().createScoped(Collections.singletonList("https://www.googleapis.com/auth/trace.append"));
    }

    @Bean(name={"projectId"})
    String projectId() {
        String configuredProject = this.storageProperties.getProjectId();
        if (configuredProject != null && !configuredProject.isEmpty()) {
            return configuredProject;
        }
        try {
            return this.getDefaultProjectId();
        }
        catch (Throwable t) {
            Call.propagateIfFatal((Throwable)t);
            throw new IllegalArgumentException("Missing required property: projectId");
        }
    }

    String getDefaultProjectId() {
        HttpClient client = HttpClient.of((String)"http://metadata.google.internal/", (ClientOptionValue[])new ClientOptionValue[0]);
        return ((AggregatedHttpResponse)client.execute(RequestHeaders.of((HttpMethod)HttpMethod.GET, (String)"/computeMetadata/v1/project/project-id", (CharSequence)"Metadata-Flavor", (String)"Google")).aggregate().join()).contentUtf8();
    }

    @Bean
    @ConditionalOnMissingBean
    ClientFactory clientFactory() {
        return ClientFactory.DEFAULT;
    }

    @Bean
    @ConditionalOnMissingBean
    StorageComponent storage(@Value(value="${zipkin.storage.strict-trace-id:true}") boolean strictTraceId, @Qualifier(value="projectId") String projectId, ClientFactory clientFactory, ZipkinStackdriverStorageProperties properties, Credentials credentials) {
        if (!OpenSsl.isAvailable() && !ZipkinStackdriverStorageModule.jettyAlpnAvailable()) {
            throw new IllegalStateException("OpenSsl or ALPN is required. This usually requires either JDK9+, jetty-alpn, or netty-tcnative-boringssl-static");
        }
        ClientOptionsBuilder options = new ClientOptionsBuilder();
        ZipkinStackdriverStorageProperties.HttpLogging httpLogging = properties.getHttpLogging();
        if (httpLogging != ZipkinStackdriverStorageProperties.HttpLogging.NONE) {
            LoggingClientBuilder loggingBuilder = (LoggingClientBuilder)((LoggingClientBuilder)new LoggingClientBuilder().requestLogLevel(LogLevel.INFO)).successfulResponseLogLevel(LogLevel.INFO);
            switch (httpLogging) {
                case HEADERS: {
                    loggingBuilder.contentSanitizer(unused -> "");
                    break;
                }
                case BASIC: {
                    loggingBuilder.contentSanitizer(unused -> "");
                    loggingBuilder.headersSanitizer(unused -> HttpHeaders.of());
                    break;
                }
            }
            options.decorator(loggingBuilder.newDecorator());
        }
        return StackdriverStorage.newBuilder((String)properties.getApiHost()).projectId(projectId).strictTraceId(strictTraceId).clientFactory(clientFactory).clientOptions(((ClientOptionsBuilder)options.decorator(CredentialsDecoratingClient.newDecorator(credentials))).build()).build();
    }

    private static boolean jettyAlpnAvailable() {
        if (PlatformDependent.javaVersion() <= 8) {
            try {
                Class.forName("sun.security.ssl.ALPNExtension", true, null);
                return true;
            }
            catch (Throwable ignore) {
                return false;
            }
        }
        return true;
    }
}

