/*
 * Decompiled with CFR 0.152.
 */
package zipkin.cassandra;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.twitter.zipkin.storage.cassandra.Repository;
import zipkin.Codec;
import zipkin.Span;
import zipkin.cassandra.CassandraUtil;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.spanstore.guava.GuavaSpanConsumer;

final class CassandraSpanConsumer
implements GuavaSpanConsumer {
    private static final Function<Object, Void> TO_VOID = Functions.constant(null);
    private final Repository repository;
    private final int spanTtl;
    private final int indexTtl;

    CassandraSpanConsumer(Repository repository, int spanTtl, int indexTtl) {
        this.repository = repository;
        this.spanTtl = spanTtl;
        this.indexTtl = indexTtl;
    }

    public ListenableFuture<Void> accept(List<Span> spans) {
        LinkedList<ListenableFuture> futures = new LinkedList<ListenableFuture>();
        for (Span span : spans) {
            span = ApplyTimestampAndDuration.apply((Span)span);
            futures.add(this.repository.storeSpan(span.traceId, span.timestamp != null ? span.timestamp : 0L, String.format("%d_%d_%d", span.id, span.annotations.hashCode(), span.binaryAnnotations.hashCode()), ByteBuffer.wrap(Codec.THRIFT.writeSpan(span)), this.spanTtl));
            for (String serviceName : span.serviceNames()) {
                futures.add(this.repository.storeServiceName(serviceName, this.indexTtl));
                if (!span.name.isEmpty()) {
                    futures.add(this.repository.storeSpanName(serviceName, span.name, this.indexTtl));
                }
                if (span.timestamp == null) continue;
                futures.add(this.repository.storeTraceIdByServiceName(serviceName, span.timestamp.longValue(), span.traceId, this.indexTtl));
                if (!span.name.isEmpty()) {
                    futures.add(this.repository.storeTraceIdBySpanName(serviceName, span.name, span.timestamp.longValue(), span.traceId, this.indexTtl));
                }
                if (span.duration == null) continue;
                futures.add(this.repository.storeTraceIdByDuration(serviceName, span.name, span.timestamp.longValue(), span.duration.longValue(), span.traceId, this.indexTtl));
                if (span.name.isEmpty()) continue;
                this.repository.storeTraceIdByDuration(serviceName, "", span.timestamp.longValue(), span.duration.longValue(), span.traceId, this.indexTtl);
            }
            if (span.timestamp == null) continue;
            for (ByteBuffer annotation : CassandraUtil.annotationKeys(span)) {
                futures.add(this.repository.storeTraceIdByAnnotation(annotation, span.timestamp.longValue(), span.traceId, this.indexTtl));
            }
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), TO_VOID);
    }
}

