/*
 * Decompiled with CFR 0.152.
 */
package zipkin.cassandra;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.twitter.zipkin.storage.cassandra.Repository;
import zipkin.Codec;
import zipkin.DependencyLink;
import zipkin.QueryRequest;
import zipkin.Span;
import zipkin.cassandra.CassandraUtil;
import zipkin.internal.CorrectForClockSkew;
import zipkin.internal.Dependencies;
import zipkin.internal.MergeById;
import zipkin.internal.Nullable;
import zipkin.internal.Pair;
import zipkin.internal.Util;
import zipkin.spanstore.guava.GuavaSpanStore;

final class CassandraSpanStore
implements GuavaSpanStore {
    static final ListenableFuture<List<String>> EMPTY_LIST = Futures.immediateFuture(Collections.emptyList());
    static final Ordering<List<Span>> TRACE_DESCENDING = Ordering.from((Comparator)new Comparator<List<Span>>(){

        @Override
        public int compare(List<Span> left, List<Span> right) {
            return right.get(0).compareTo(left.get(0));
        }
    });
    private final Repository repository;
    private final int indexTtl;
    private final int maxTraceCols;

    CassandraSpanStore(Repository repository, int indexTtl, int maxTraceCols) {
        this.repository = repository;
        this.indexTtl = indexTtl;
        this.maxTraceCols = maxTraceCols;
    }

    public ListenableFuture<List<List<Span>>> getTraces(QueryRequest request) {
        ListenableFuture traceIds;
        String spanName;
        String string = spanName = request.spanName != null ? request.spanName : "";
        ListenableFuture traceIdToTimestamp = request.minDuration != null || request.maxDuration != null ? this.repository.getTraceIdsByDuration(request.serviceName, spanName, request.minDuration.longValue(), request.maxDuration != null ? request.maxDuration : Long.MAX_VALUE, request.endTs * 1000L, (request.endTs - request.lookback) * 1000L, request.limit, this.indexTtl) : (!spanName.isEmpty() ? this.repository.getTraceIdsBySpanName(request.serviceName, spanName, request.endTs * 1000L, request.lookback * 1000L, request.limit) : this.repository.getTraceIdsByServiceName(request.serviceName, request.endTs * 1000L, request.lookback * 1000L, request.limit));
        List<ByteBuffer> annotationKeys = CassandraUtil.annotationKeys(request);
        if (annotationKeys.isEmpty()) {
            traceIds = Futures.transform((ListenableFuture)traceIdToTimestamp, CassandraUtil.keyset());
        } else {
            ArrayList<ListenableFuture> futureKeySetsToIntersect = new ArrayList<ListenableFuture>();
            futureKeySetsToIntersect.add(traceIdToTimestamp);
            for (ByteBuffer annotationKey : annotationKeys) {
                futureKeySetsToIntersect.add(this.repository.getTraceIdsByAnnotation(annotationKey, request.endTs * 1000L, request.lookback * 1000L, request.limit));
            }
            traceIds = Futures.transform((ListenableFuture)Futures.allAsList(futureKeySetsToIntersect), CassandraUtil.intersectKeySets());
        }
        return Futures.transform((ListenableFuture)traceIds, (AsyncFunction)new AsyncFunction<Set<Long>, List<List<Span>>>(){

            public ListenableFuture<List<List<Span>>> apply(Set<Long> traceIds) {
                return Futures.transform((ListenableFuture)CassandraSpanStore.this.repository.getSpansByTraceIds(traceIds.toArray(new Long[traceIds.size()]), CassandraSpanStore.this.maxTraceCols), (Function)ConvertTracesResponse.INSTANCE);
            }

            public String toString() {
                return "getSpansByTraceIds";
            }
        });
    }

    public ListenableFuture<List<Span>> getRawTrace(long traceId) {
        return Futures.transform((ListenableFuture)this.repository.getSpansByTraceIds(new Long[]{traceId}, this.maxTraceCols), (Function)new Function<Map<Long, List<ByteBuffer>>, List<Span>>(){

            public List<Span> apply(Map<Long, List<ByteBuffer>> encodedTraces) {
                if (encodedTraces.isEmpty()) {
                    return null;
                }
                List<ByteBuffer> encodedTrace = encodedTraces.values().iterator().next();
                ImmutableList.Builder result = ImmutableList.builder();
                for (ByteBuffer encodedSpan : encodedTrace) {
                    result.add((Object)Codec.THRIFT.readSpan(encodedSpan));
                }
                return result.build();
            }
        });
    }

    public ListenableFuture<List<Span>> getTrace(long traceId) {
        return Futures.transform(this.getRawTrace(traceId), (Function)new Function<List<Span>, List<Span>>(){

            public List<Span> apply(List<Span> input) {
                if (input == null || input.isEmpty()) {
                    return null;
                }
                return ImmutableList.copyOf((Collection)CorrectForClockSkew.apply((List)MergeById.apply(input)));
            }
        });
    }

    public ListenableFuture<List<String>> getServiceNames() {
        return Futures.transform((ListenableFuture)this.repository.getServiceNames(), CassandraUtil.toSortedList());
    }

    public ListenableFuture<List<String>> getSpanNames(String service) {
        if (service == null) {
            return EMPTY_LIST;
        }
        return Futures.transform((ListenableFuture)this.repository.getSpanNames(service.toLowerCase()), CassandraUtil.toSortedList());
    }

    public ListenableFuture<List<DependencyLink>> getDependencies(long endTs, @Nullable Long lookback) {
        long endEpochDayMillis = Util.midnightUTC((long)endTs);
        long startEpochDayMillis = Util.midnightUTC((long)(endTs - (lookback != null ? lookback : endTs)));
        return Futures.transform((ListenableFuture)this.repository.getDependencies(startEpochDayMillis, endEpochDayMillis), (Function)ConvertDependenciesResponse.INSTANCE);
    }

    static enum ConvertDependenciesResponse implements Function<List<ByteBuffer>, List<DependencyLink>>
    {
        INSTANCE;


        public List<DependencyLink> apply(List<ByteBuffer> encodedDailyDependencies) {
            LinkedHashMap<Pair, Long> links = new LinkedHashMap<Pair, Long>(encodedDailyDependencies.size());
            for (ByteBuffer encodedDayOfDependencies : encodedDailyDependencies) {
                for (DependencyLink link : Dependencies.fromThrift((ByteBuffer)encodedDayOfDependencies).links) {
                    Pair parentChild = Pair.create((Object)link.parent, (Object)link.child);
                    long callCount = links.containsKey(parentChild) ? (Long)links.get(parentChild) : 0L;
                    links.put(parentChild, callCount += link.callCount);
                }
            }
            ArrayList<DependencyLink> result = new ArrayList<DependencyLink>(links.size());
            for (Map.Entry link : links.entrySet()) {
                result.add(DependencyLink.create((String)((String)((Pair)link.getKey())._1), (String)((String)((Pair)link.getKey())._2), (long)((Long)link.getValue())));
            }
            return result;
        }
    }

    static enum ConvertTracesResponse implements Function<Map<Long, List<ByteBuffer>>, List<List<Span>>>
    {
        INSTANCE;


        public List<List<Span>> apply(Map<Long, List<ByteBuffer>> input) {
            Collection<List<ByteBuffer>> encodedTraces = input.values();
            ArrayList<List> result = new ArrayList<List>(encodedTraces.size());
            for (List<ByteBuffer> encodedTrace : encodedTraces) {
                ArrayList<Span> spans = new ArrayList<Span>(encodedTrace.size());
                for (ByteBuffer encodedSpan : encodedTrace) {
                    spans.add(Codec.THRIFT.readSpan(encodedSpan));
                }
                result.add(CorrectForClockSkew.apply((List)MergeById.apply(spans)));
            }
            return TRACE_DESCENDING.immutableSortedCopy(result);
        }
    }
}

