/*
 * Decompiled with CFR 0.152.
 */
package zipkin.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.twitter.zipkin.storage.cassandra.Repository;
import zipkin.DependencyLink;
import zipkin.cassandra.CassandraSpanConsumer;
import zipkin.cassandra.CassandraSpanStore;
import zipkin.cassandra.ClusterProvider;
import zipkin.cassandra.LazyRepository;
import zipkin.internal.Dependencies;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.spanstore.guava.LazyGuavaStorageComponent;

public final class CassandraStorage
extends LazyGuavaStorageComponent<CassandraSpanStore, CassandraSpanConsumer> {
    final String keyspace;
    final int maxTraceCols;
    final int indexTtl;
    final int spanTtl;
    final ClusterProvider clusterProvider;
    final LazyRepository lazyRepository;

    CassandraStorage(Builder builder) {
        this.maxTraceCols = builder.maxTraceCols;
        this.indexTtl = builder.indexTtl;
        this.spanTtl = builder.spanTtl;
        this.keyspace = builder.keyspace;
        this.clusterProvider = new ClusterProvider(builder);
        this.lazyRepository = new LazyRepository(builder);
    }

    protected CassandraSpanStore computeGuavaSpanStore() {
        return new CassandraSpanStore((Repository)this.lazyRepository.get(), this.indexTtl, this.maxTraceCols);
    }

    protected CassandraSpanConsumer computeGuavaSpanConsumer() {
        return new CassandraSpanConsumer((Repository)this.lazyRepository.get(), this.spanTtl, this.indexTtl);
    }

    public void close() {
        this.lazyRepository.close();
    }

    @VisibleForTesting
    void writeDependencyLinks(List<DependencyLink> links, long timestampMillis) {
        long midnight = Util.midnightUTC((long)timestampMillis);
        Dependencies deps = Dependencies.create((long)midnight, (long)midnight, links);
        ByteBuffer thrift = deps.toThrift();
        Futures.getUnchecked((Future)((Repository)this.lazyRepository.get()).storeDependencies(midnight, thrift));
    }

    @VisibleForTesting
    void clear() {
        try (Cluster cluster = this.clusterProvider.get();
             Session session = cluster.connect();){
            LinkedList<ResultSetFuture> futures = new LinkedList<ResultSetFuture>();
            for (String cf : ImmutableList.of((Object)"traces", (Object)"dependencies", (Object)"service_names", (Object)"span_names", (Object)"service_name_index", (Object)"service_span_name_index", (Object)"annotations_index", (Object)"span_duration_index")) {
                futures.add(session.executeAsync(String.format("TRUNCATE %s.%s", this.keyspace, cf)));
            }
            Futures.getUnchecked((Future)Futures.allAsList(futures));
        }
    }

    public static final class Builder {
        String keyspace = "zipkin";
        String contactPoints = "localhost";
        String localDc;
        int maxConnections = 8;
        boolean ensureSchema = true;
        String username;
        String password;
        int maxTraceCols = 100000;
        int spanTtl = (int)TimeUnit.DAYS.toSeconds(7L);
        int indexTtl = (int)TimeUnit.DAYS.toSeconds(3L);

        public Builder keyspace(String keyspace) {
            this.keyspace = (String)Util.checkNotNull((Object)keyspace, (String)"keyspace");
            return this;
        }

        public Builder contactPoints(String contactPoints) {
            this.contactPoints = (String)Util.checkNotNull((Object)contactPoints, (String)"contactPoints");
            return this;
        }

        public Builder localDc(@Nullable String localDc) {
            this.localDc = localDc;
            return this;
        }

        public Builder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder ensureSchema(boolean ensureSchema) {
            this.ensureSchema = ensureSchema;
            return this;
        }

        public Builder username(@Nullable String username) {
            this.username = username;
            return this;
        }

        public Builder password(@Nullable String password) {
            this.password = password;
            return this;
        }

        public Builder maxTraceCols(int maxTraceCols) {
            this.maxTraceCols = maxTraceCols;
            return this;
        }

        public Builder spanTtl(int spanTtl) {
            this.spanTtl = spanTtl;
            return this;
        }

        public Builder indexTtl(int indexTtl) {
            this.indexTtl = indexTtl;
            return this;
        }

        public CassandraStorage build() {
            return new CassandraStorage(this);
        }
    }
}

