/*
 * Decompiled with CFR 0.152.
 */
package zipkin.cassandra;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.QueryRequest;
import zipkin.Span;
import zipkin.internal.Util;

final class CassandraUtil {
    static final ThreadLocal<CharsetEncoder> UTF8_ENCODER = new ThreadLocal<CharsetEncoder>(){

        @Override
        protected CharsetEncoder initialValue() {
            return Util.UTF_8.newEncoder();
        }
    };

    CassandraUtil() {
    }

    static List<ByteBuffer> annotationKeys(Span span) {
        LinkedHashSet<String> annotationKeys = new LinkedHashSet<String>();
        for (Annotation a : span.annotations) {
            if (a.endpoint == null || a.endpoint.serviceName.isEmpty()) continue;
            annotationKeys.add(a.endpoint.serviceName + ":" + a.value);
        }
        for (BinaryAnnotation b : span.binaryAnnotations) {
            if (b.type != BinaryAnnotation.Type.STRING || b.endpoint == null || b.endpoint.serviceName.isEmpty()) continue;
            annotationKeys.add(b.endpoint.serviceName + ":" + b.key);
            annotationKeys.add(b.endpoint.serviceName + ":" + b.key + ":" + new String(b.value, Util.UTF_8));
        }
        return CassandraUtil.toByteBuffers(annotationKeys);
    }

    static List<ByteBuffer> annotationKeys(QueryRequest request) {
        LinkedHashSet<String> annotationKeys = new LinkedHashSet<String>();
        for (String string : request.annotations) {
            annotationKeys.add(request.serviceName + ":" + string);
        }
        for (Map.Entry entry : request.binaryAnnotations.entrySet()) {
            annotationKeys.add(request.serviceName + ":" + (String)entry.getKey() + ":" + (String)entry.getValue());
        }
        return CassandraUtil.toByteBuffers(annotationKeys);
    }

    private static List<ByteBuffer> toByteBuffers(Collection<String> strings) {
        if (strings.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>(strings.size());
        for (String string : strings) {
            try {
                result.add(UTF8_ENCODER.get().encode(CharBuffer.wrap(string)));
            }
            catch (CharacterCodingException characterCodingException) {}
        }
        return result;
    }

    static <K, V> Function<Map<K, V>, Set<K>> keyset() {
        return KeySet.INSTANCE;
    }

    static <K, V> Function<List<Map<K, V>>, Set<K>> intersectKeySets() {
        return IntersectKeySets.INSTANCE;
    }

    static <E extends Comparable> Function<Iterable<E>, List<E>> toSortedList() {
        return ToSortedList.INSTANCE;
    }

    static enum ToSortedList implements Function<Iterable<Comparable>, List<Comparable>>
    {
        INSTANCE;


        public List<Comparable> apply(Iterable<Comparable> input) {
            return Ordering.natural().sortedCopy(input);
        }
    }

    static enum IntersectKeySets implements Function<List<Map<Object, ?>>, Set<Object>>
    {
        INSTANCE;


        public Set<Object> apply(List<Map<Object, ?>> input) {
            LinkedHashSet traceIds = Sets.newLinkedHashSet(input.get(0).keySet());
            for (int i = 1; i < input.size(); ++i) {
                traceIds.retainAll(input.get(i).keySet());
            }
            return traceIds;
        }
    }

    static enum KeySet implements Function<Map<Object, ?>, Set<Object>>
    {
        INSTANCE;


        public Set<Object> apply(Map<Object, ?> input) {
            return input.keySet();
        }
    }
}

