/*
 * Decompiled with CFR 0.152.
 */
package zipkin.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LatencyAwarePolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import java.net.InetSocketAddress;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.twitter.zipkin.storage.cassandra.ZipkinRetryPolicy;
import zipkin.cassandra.CassandraStorage;

final class ClusterProvider {
    final String contactPoints;
    final int maxConnections;
    final String localDc;
    final String username;
    final String password;

    ClusterProvider(CassandraStorage.Builder builder) {
        this.contactPoints = builder.contactPoints;
        this.maxConnections = builder.maxConnections;
        this.localDc = builder.localDc;
        this.username = builder.username;
        this.password = builder.password;
    }

    Cluster get() {
        Cluster.Builder builder = Cluster.builder();
        List<InetSocketAddress> contactPoints = this.parseContactPoints();
        int defaultPort = ClusterProvider.findConnectPort(contactPoints);
        builder.addContactPointsWithPorts(contactPoints);
        builder.withPort(defaultPort);
        if (this.username != null && this.password != null) {
            builder.withCredentials(this.username, this.password);
        }
        builder.withRetryPolicy((RetryPolicy)ZipkinRetryPolicy.INSTANCE);
        builder.withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new LatencyAwarePolicy.Builder((LoadBalancingPolicy)(this.localDc != null ? DCAwareRoundRobinPolicy.builder().withLocalDc(this.localDc).build() : new RoundRobinPolicy())).build()));
        builder.withPoolingOptions(new PoolingOptions().setMaxConnectionsPerHost(HostDistance.LOCAL, this.maxConnections));
        return builder.build();
    }

    List<InetSocketAddress> parseContactPoints() {
        LinkedList<InetSocketAddress> result = new LinkedList<InetSocketAddress>();
        for (String contactPoint : this.contactPoints.split(",")) {
            HostAndPort parsed = HostAndPort.fromString((String)contactPoint);
            result.add(new InetSocketAddress(parsed.getHostText(), parsed.getPortOrDefault(9042)));
        }
        return result;
    }

    static int findConnectPort(List<InetSocketAddress> contactPoints) {
        LinkedHashSet ports = Sets.newLinkedHashSet();
        for (InetSocketAddress contactPoint : contactPoints) {
            ports.add(contactPoint.getPort());
        }
        return ports.size() == 1 ? (Integer)ports.iterator().next() : 9042;
    }
}

