/*
 * Decompiled with CFR 0.152.
 */
package zipkin.cassandra;

import com.datastax.driver.core.Cluster;
import org.twitter.zipkin.storage.cassandra.Repository;
import zipkin.cassandra.CassandraStorage;
import zipkin.cassandra.ClusterProvider;
import zipkin.internal.Lazy;

final class LazyRepository
extends Lazy<Repository>
implements AutoCloseable {
    private final ClusterProvider clusterProvider;
    private final String keyspace;
    private final boolean ensureSchema;

    LazyRepository(CassandraStorage.Builder builder) {
        this.clusterProvider = new ClusterProvider(builder);
        this.keyspace = builder.keyspace;
        this.ensureSchema = builder.ensureSchema;
    }

    protected Repository compute() {
        Cluster cluster = this.clusterProvider.get();
        try {
            return new Repository(this.keyspace, cluster, Boolean.valueOf(this.ensureSchema));
        }
        catch (RuntimeException e) {
            cluster.close();
            throw e;
        }
    }

    @Override
    public void close() {
        Repository maybeNull = (Repository)this.maybeGet();
        if (maybeNull != null) {
            maybeNull.close();
        }
    }
}

