/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.autoconfigure.storage.mysql;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.ThreadLocalSpan;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import zipkin2.Endpoint;
import zipkin2.autoconfigure.storage.mysql.ZipkinMySQLStorageProperties;

@ConditionalOnBean(value={Tracing.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="mysql")
@Configuration
public class TracingZipkinMySQLStorageAutoConfiguration
extends DefaultExecuteListener {
    @Autowired
    ZipkinMySQLStorageProperties mysql;
    @Autowired
    @Qualifier(value="mysql")
    Endpoint mysqlEndpoint;
    @Autowired
    @Qualifier(value="mysql")
    ThreadLocalSpan threadLocalSpan;
    @Autowired
    CurrentTraceContext currentTraceContext;

    @Bean
    ExecuteListenerProvider tracingExecuteListenerProvider() {
        return new DefaultExecuteListenerProvider((ExecuteListener)this);
    }

    @Bean
    @ConditionalOnMissingBean(value={Executor.class})
    public Executor executor(CurrentTraceContext currentTraceContext) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("MySQLStorage-");
        executor.initialize();
        return currentTraceContext.executor((Executor)executor);
    }

    @Bean
    @Qualifier(value="mysql")
    Endpoint mysql() throws UnknownHostException {
        Endpoint.Builder builder = Endpoint.newBuilder().serviceName("mysql");
        builder.parseIp(InetAddress.getByName(this.mysql.getHost()));
        return builder.port(this.mysql.getPort()).build();
    }

    @Bean
    @Qualifier(value="mysql")
    ThreadLocalSpan mysqlThreadLocalSpan(Tracing tracing) {
        return ThreadLocalSpan.create((Tracer)tracing.tracer());
    }

    public void renderEnd(ExecuteContext ctx) {
        if (this.currentTraceContext.get() == null) {
            return;
        }
        Span span = this.threadLocalSpan.next();
        if (span == null || span.isNoop()) {
            return;
        }
        String sql = ctx.sql();
        int spaceIndex = sql.indexOf(32);
        span.kind(Span.Kind.CLIENT).name(spaceIndex == -1 ? sql : sql.substring(0, spaceIndex));
        span.tag("sql.query", sql);
        span.remoteEndpoint(this.mysqlEndpoint);
        span.start();
    }

    public void executeEnd(ExecuteContext ctx) {
        Span span = ThreadLocalSpan.CURRENT_TRACER.remove();
        if (span == null || span.isNoop()) {
            return;
        }
        if (ctx.sqlException() != null) {
            span.tag("error", Integer.toString(ctx.sqlException().getErrorCode()));
        }
        span.finish();
    }
}

