/*
 * Decompiled with CFR 0.152.
 */
package zipkin.collector.kafka;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import kafka.consumer.Consumer;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.KafkaStream;
import kafka.javaapi.consumer.ZookeeperConsumerConnector;
import zipkin.Component;
import zipkin.collector.Collector;
import zipkin.collector.CollectorComponent;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.CollectorSampler;
import zipkin.collector.kafka.KafkaCollector$LazyStreams$$Lambda$1;
import zipkin.collector.kafka.KafkaStreamProcessor;
import zipkin.internal.LazyCloseable;
import zipkin.internal.Util;
import zipkin.storage.StorageComponent;

public final class KafkaCollector
implements CollectorComponent {
    final LazyConnector connector;
    final LazyStreams streams;

    public static Builder builder() {
        return new Builder();
    }

    KafkaCollector(Builder builder) {
        this.connector = new LazyConnector(builder);
        this.streams = new LazyStreams(builder, this.connector);
    }

    public KafkaCollector start() {
        this.connector.get();
        this.streams.get();
        return this;
    }

    public Component.CheckResult check() {
        try {
            this.connector.get();
            Component.CheckResult failure = this.streams.failure.get();
            if (failure != null) {
                return failure;
            }
            return Component.CheckResult.OK;
        }
        catch (RuntimeException e) {
            return Component.CheckResult.failed((Exception)e);
        }
    }

    public void close() throws IOException {
        this.streams.close();
        this.connector.close();
    }

    static final class LazyStreams
    extends LazyCloseable<ExecutorService> {
        final int streams;
        final String topic;
        final Collector collector;
        final CollectorMetrics metrics;
        final LazyCloseable<ZookeeperConsumerConnector> connector;
        final AtomicReference<Component.CheckResult> failure = new AtomicReference();

        LazyStreams(Builder builder, LazyCloseable<ZookeeperConsumerConnector> connector) {
            this.streams = builder.streams;
            this.topic = builder.topic;
            this.collector = builder.delegate.build();
            this.metrics = builder.metrics;
            this.connector = connector;
        }

        protected ExecutorService compute() {
            ExecutorService pool = this.streams == 1 ? Executors.newSingleThreadExecutor() : Executors.newFixedThreadPool(this.streams);
            LinkedHashMap<String, Integer> topicCountMap = new LinkedHashMap<String, Integer>(1);
            topicCountMap.put(this.topic, this.streams);
            for (KafkaStream stream : (List)((ZookeeperConsumerConnector)this.connector.get()).createMessageStreams(topicCountMap).get(this.topic)) {
                pool.execute(this.guardFailures(new KafkaStreamProcessor((KafkaStream<byte[], byte[]>)stream, this.collector, this.metrics)));
            }
            return pool;
        }

        Runnable guardFailures(Runnable delegate) {
            return KafkaCollector$LazyStreams$$Lambda$1.lambdaFactory$(this, delegate);
        }

        public void close() {
            ExecutorService maybeNull = (ExecutorService)this.maybeNull();
            if (maybeNull != null) {
                maybeNull.shutdown();
            }
        }

        /* synthetic */ void lambda$guardFailures$0(Runnable delegate) {
            try {
                delegate.run();
            }
            catch (RuntimeException e) {
                this.failure.set(Component.CheckResult.failed((Exception)e));
            }
        }
    }

    static final class LazyConnector
    extends LazyCloseable<ZookeeperConsumerConnector> {
        final ConsumerConfig config;

        LazyConnector(Builder builder) {
            this.config = new ConsumerConfig(builder.properties);
        }

        protected ZookeeperConsumerConnector compute() {
            return (ZookeeperConsumerConnector)Consumer.createJavaConsumerConnector((ConsumerConfig)this.config);
        }

        public void close() {
            ZookeeperConsumerConnector maybeNull = (ZookeeperConsumerConnector)this.maybeNull();
            if (maybeNull != null) {
                maybeNull.shutdown();
            }
        }
    }

    public static final class Builder
    implements CollectorComponent.Builder {
        final Properties properties = new Properties();
        Collector.Builder delegate = Collector.builder(KafkaCollector.class);
        CollectorMetrics metrics = CollectorMetrics.NOOP_METRICS;
        String topic = "zipkin";
        int streams = 1;

        public Builder storage(StorageComponent storage) {
            this.delegate.storage(storage);
            return this;
        }

        public Builder sampler(CollectorSampler sampler) {
            this.delegate.sampler(sampler);
            return this;
        }

        public Builder metrics(CollectorMetrics metrics) {
            this.metrics = ((CollectorMetrics)Util.checkNotNull((Object)metrics, (String)"metrics")).forTransport("kafka");
            this.delegate.metrics(this.metrics);
            return this;
        }

        public Builder topic(String topic) {
            this.topic = (String)Util.checkNotNull((Object)topic, (String)"topic");
            return this;
        }

        public Builder zookeeper(String zookeeper) {
            this.properties.put("zookeeper.connect", Util.checkNotNull((Object)zookeeper, (String)"zookeeper"));
            return this;
        }

        public Builder groupId(String groupId) {
            this.properties.put("group.id", Util.checkNotNull((Object)groupId, (String)"groupId"));
            return this;
        }

        public Builder streams(int streams) {
            this.streams = streams;
            return this;
        }

        public Builder maxMessageSize(int bytes) {
            this.properties.put("fetch.message.max.bytes", String.valueOf(bytes));
            return this;
        }

        public final Builder overrides(Map<String, String> overrides) {
            this.properties.putAll((Map<?, ?>)((Map)Util.checkNotNull(overrides, (String)"overrides")));
            return this;
        }

        public KafkaCollector build() {
            return new KafkaCollector(this);
        }

        Builder() {
            this.properties.put("group.id", "zipkin");
            this.properties.put("fetch.message.max.bytes", String.valueOf(0x100000));
            this.properties.put("auto.offset.reset", "smallest");
        }
    }
}

