/*
 * Decompiled with CFR 0.152.
 */
package zipkin.collector.kafka;

import java.util.Collections;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import zipkin.Codec;
import zipkin.collector.Collector;
import zipkin.collector.CollectorMetrics;
import zipkin.storage.Callback;

final class KafkaStreamProcessor
implements Runnable {
    final KafkaStream<byte[], byte[]> stream;
    final Collector collector;
    final CollectorMetrics metrics;

    KafkaStreamProcessor(KafkaStream<byte[], byte[]> stream, Collector collector, CollectorMetrics metrics) {
        this.stream = stream;
        this.collector = collector;
        this.metrics = metrics;
    }

    @Override
    public void run() {
        ConsumerIterator messages = this.stream.iterator();
        while (messages.hasNext()) {
            byte[] bytes = (byte[])messages.next().message();
            this.metrics.incrementMessages();
            if (bytes.length == 0) {
                this.metrics.incrementMessagesDropped();
                continue;
            }
            if (bytes[0] == 91) {
                this.collector.acceptSpans(bytes, (Codec)Codec.JSON, Callback.NOOP);
                continue;
            }
            if (bytes[0] == 12) {
                this.collector.acceptSpans(bytes, (Codec)Codec.THRIFT, Callback.NOOP);
                continue;
            }
            this.collector.acceptSpans(Collections.singletonList(bytes), (Codec)Codec.THRIFT, Callback.NOOP);
        }
    }
}

