/*
 * Decompiled with CFR 0.152.
 */
package zipkin.collector.kafka10;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin.Component;
import zipkin.collector.Collector;
import zipkin.collector.CollectorComponent;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.CollectorSampler;
import zipkin.collector.kafka10.KafkaCollector$LazyKafkaWorkers$$Lambda$1;
import zipkin.collector.kafka10.KafkaCollectorWorker;
import zipkin.internal.LazyCloseable;
import zipkin.internal.Util;
import zipkin.storage.StorageComponent;

public final class KafkaCollector
implements CollectorComponent {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaCollector.class);
    final LazyKafkaWorkers kafkaWorkers;

    public static Builder builder() {
        return new Builder();
    }

    KafkaCollector(Builder builder) {
        this.kafkaWorkers = new LazyKafkaWorkers(builder);
    }

    public KafkaCollector start() {
        this.kafkaWorkers.get();
        return this;
    }

    public Component.CheckResult check() {
        try {
            Component.CheckResult failure = this.kafkaWorkers.failure.get();
            if (failure != null) {
                return failure;
            }
            return Component.CheckResult.OK;
        }
        catch (RuntimeException e) {
            return Component.CheckResult.failed((Exception)e);
        }
    }

    public void close() throws IOException {
        this.kafkaWorkers.close();
    }

    static final class LazyKafkaWorkers
    extends LazyCloseable<ExecutorService> {
        final int streams;
        final Builder builder;
        final AtomicReference<Component.CheckResult> failure = new AtomicReference();
        final CopyOnWriteArrayList<KafkaCollectorWorker> workers = new CopyOnWriteArrayList();

        LazyKafkaWorkers(Builder builder) {
            this.streams = builder.streams;
            this.builder = builder;
        }

        protected ExecutorService compute() {
            ExecutorService pool = this.streams == 1 ? Executors.newSingleThreadExecutor() : Executors.newFixedThreadPool(this.streams);
            for (int i = 0; i < this.streams; ++i) {
                KafkaCollectorWorker worker = new KafkaCollectorWorker(this.builder);
                this.workers.add(worker);
                pool.execute(this.guardFailures(worker));
            }
            return pool;
        }

        Runnable guardFailures(Runnable delegate) {
            return KafkaCollector$LazyKafkaWorkers$$Lambda$1.lambdaFactory$(this, delegate);
        }

        public void close() {
            ExecutorService maybeNull = (ExecutorService)this.maybeNull();
            if (maybeNull != null) {
                maybeNull.shutdownNow();
                try {
                    maybeNull.awaitTermination(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ void lambda$guardFailures$0(LazyKafkaWorkers this_, Runnable delegate) {
            try {
                delegate.run();
            }
            catch (InterruptException e) {
                LOG.info("Kafka collector worker was interrupted. This is expected during shutdown.", (Throwable)e);
                this_.failure.set(Component.CheckResult.failed((Exception)((Object)e)));
            }
            catch (RuntimeException e) {
                LOG.error("Kafka collector worker exited with exception.", (Throwable)e);
                this_.failure.set(Component.CheckResult.failed((Exception)e));
            }
        }
    }

    public static final class Builder
    implements CollectorComponent.Builder {
        final Properties properties = new Properties();
        Collector.Builder delegate = Collector.builder(KafkaCollector.class);
        CollectorMetrics metrics = CollectorMetrics.NOOP_METRICS;
        String topic = "zipkin";
        int streams = 1;

        public Builder storage(StorageComponent storage) {
            this.delegate.storage(storage);
            return this;
        }

        public Builder sampler(CollectorSampler sampler) {
            this.delegate.sampler(sampler);
            return this;
        }

        public Builder metrics(CollectorMetrics metrics) {
            this.metrics = ((CollectorMetrics)Util.checkNotNull((Object)metrics, (String)"metrics")).forTransport("kafka");
            this.delegate.metrics(this.metrics);
            return this;
        }

        public Builder topic(String topic) {
            this.topic = (String)Util.checkNotNull((Object)topic, (String)"topic");
            return this;
        }

        public Builder bootstrapServers(String bootstrapServers) {
            this.properties.put("bootstrap.servers", Util.checkNotNull((Object)bootstrapServers, (String)"bootstrapServers"));
            return this;
        }

        public Builder groupId(String groupId) {
            this.properties.put("group.id", Util.checkNotNull((Object)groupId, (String)"groupId"));
            return this;
        }

        public Builder streams(int streams) {
            this.streams = streams;
            return this;
        }

        public final Builder overrides(Map<String, String> overrides) {
            this.properties.putAll((Map<?, ?>)((Map)Util.checkNotNull(overrides, (String)"overrides")));
            return this;
        }

        public KafkaCollector build() {
            return new KafkaCollector(this);
        }

        Builder() {
            this.properties.put("group.id", "zipkin");
            this.properties.put("auto.offset.reset", "earliest");
            this.properties.put("key.deserializer", ByteArrayDeserializer.class.getName());
            this.properties.put("value.deserializer", ByteArrayDeserializer.class.getName());
        }
    }
}

