/*
 * Decompiled with CFR 0.152.
 */
package zipkin.collector.scribe;

import com.facebook.nifty.processor.NiftyProcessor;
import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.service.ThriftServer;
import com.facebook.swift.service.ThriftServerConfig;
import com.facebook.swift.service.ThriftServiceProcessor;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.Collections;
import zipkin.Component;
import zipkin.collector.Collector;
import zipkin.collector.CollectorComponent;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.CollectorSampler;
import zipkin.collector.scribe.ScribeSpanConsumer;
import zipkin.internal.Util;
import zipkin.storage.StorageComponent;

public final class ScribeCollector
implements CollectorComponent,
Closeable {
    final ThriftServer server;

    public static Builder builder() {
        return new Builder();
    }

    ScribeCollector(Builder builder) {
        ScribeSpanConsumer scribe = new ScribeSpanConsumer(builder);
        ThriftServiceProcessor processor = new ThriftServiceProcessor(new ThriftCodecManager(new ThriftCodec[0]), Collections.emptyList(), new Object[]{scribe});
        this.server = new ThriftServer((NiftyProcessor)processor, new ThriftServerConfig().setPort(builder.port));
    }

    public ScribeCollector start() {
        this.server.start();
        return this;
    }

    public Component.CheckResult check() {
        try {
            Preconditions.checkState((boolean)this.server.isRunning(), (Object)"server not running");
        }
        catch (RuntimeException e) {
            return Component.CheckResult.failed((Exception)e);
        }
        return Component.CheckResult.OK;
    }

    @Override
    public void close() {
        this.server.close();
    }

    public static final class Builder
    implements CollectorComponent.Builder {
        Collector.Builder delegate = Collector.builder(ScribeCollector.class);
        CollectorMetrics metrics;
        String category = "zipkin";
        int port = 9410;

        public Builder storage(StorageComponent storage) {
            this.delegate.storage(storage);
            return this;
        }

        public Builder metrics(CollectorMetrics metrics) {
            this.metrics = ((CollectorMetrics)Util.checkNotNull((Object)metrics, (String)"metrics")).forTransport("scribe");
            this.delegate.metrics(this.metrics);
            return this;
        }

        public Builder sampler(CollectorSampler sampler) {
            this.delegate.sampler(sampler);
            return this;
        }

        public Builder category(String category) {
            this.category = (String)Util.checkNotNull((Object)category, (String)"category");
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public ScribeCollector build() {
            return new ScribeCollector(this);
        }
    }
}

