/*
 * Decompiled with CFR 0.152.
 */
package zipkin.collector.scribe;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import zipkin.Codec;
import zipkin.collector.Collector;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.scribe.Scribe;
import zipkin.collector.scribe.ScribeCollector;
import zipkin.internal.Nullable;
import zipkin.storage.Callback;

final class ScribeSpanConsumer
implements Scribe {
    final Collector collector;
    final CollectorMetrics metrics;
    final String category;

    public ScribeSpanConsumer(ScribeCollector.Builder builder) {
        this.collector = builder.delegate.build();
        this.metrics = builder.metrics;
        this.category = builder.category;
    }

    @Override
    public ListenableFuture<Scribe.ResultCode> log(List<Scribe.LogEntry> messages) {
        List thrifts;
        this.metrics.incrementMessages();
        try {
            thrifts = messages.stream().filter(m -> m.category.equals(this.category)).map(m -> m.message.getBytes(StandardCharsets.ISO_8859_1)).map(b -> Base64.getMimeDecoder().decode((byte[])b)).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            this.metrics.incrementMessagesDropped();
            return Futures.immediateFailedFuture((Throwable)e);
        }
        final SettableFuture result = SettableFuture.create();
        this.collector.acceptSpans(thrifts, (Codec)Codec.THRIFT, (Callback)new Callback<Void>(){

            public void onSuccess(@Nullable Void value) {
                result.set((Object)Scribe.ResultCode.OK);
            }

            public void onError(Throwable t) {
                result.setException(t);
            }
        });
        return result;
    }
}

