/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.utils.Bytes;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin.DependencyLink;
import zipkin.internal.Dependencies;
import zipkin.internal.Util;
import zipkin.storage.cassandra.CassandraUtil;

final class CassandraDependenciesWriter {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraDependenciesWriter.class);
    private final PreparedStatement insertDependencies;
    private final Session session;

    CassandraDependenciesWriter(Session session) {
        this.session = session;
        this.insertDependencies = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"dependencies").value("day", (Object)QueryBuilder.bindMarker((String)"day")).value("dependencies", (Object)QueryBuilder.bindMarker((String)"dependencies")));
    }

    @VisibleForTesting
    void write(List<DependencyLink> links, long timestampMillis) {
        long midnight = Util.midnightUTC((long)timestampMillis);
        Dependencies deps = Dependencies.create((long)midnight, (long)midnight, links);
        ByteBuffer thrift = deps.toThrift();
        Futures.getUnchecked(this.storeDependencies(midnight, thrift));
    }

    ListenableFuture<?> storeDependencies(long epochDayMillis, ByteBuffer dependencies) {
        Date startFlooredToDay = new Date(epochDayMillis);
        try {
            BoundStatement bound = CassandraUtil.bindWithName(this.insertDependencies, "insert-dependencies").setTimestamp("day", startFlooredToDay).setBytes("dependencies", dependencies);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.debugInsertDependencies(startFlooredToDay, dependencies));
            }
            return this.session.executeAsync((Statement)bound);
        }
        catch (RuntimeException ex) {
            LOG.error("failed " + this.debugInsertDependencies(startFlooredToDay, dependencies), (Throwable)ex);
            return Futures.immediateFailedFuture((Throwable)ex);
        }
    }

    private String debugInsertDependencies(Date startFlooredToDay, ByteBuffer dependencies) {
        return this.insertDependencies.getQueryString().replace(":day", CassandraUtil.iso8601(startFlooredToDay.getTime() * 1000L)).replace(":dependencies", Bytes.toHexString((ByteBuffer)dependencies));
    }
}

