/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Span;
import zipkin.internal.Util;
import zipkin.storage.QueryRequest;
import zipkin.storage.cassandra.NamedBoundStatement;

final class CassandraUtil {
    private static final long DURATION_INDEX_BUCKET_WINDOW_SECONDS = Long.getLong("zipkin.store.cassandra.internal.durationIndexBucket", 3600L);
    private static final ThreadLocal<CharsetEncoder> UTF8_ENCODER = new ThreadLocal<CharsetEncoder>(){

        @Override
        protected CharsetEncoder initialValue() {
            return Util.UTF_8.newEncoder();
        }
    };
    static final ThreadLocal<SimpleDateFormat> DATE_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat result = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
            result.setTimeZone(TimeZone.getTimeZone("UTC"));
            return result;
        }
    };

    CassandraUtil() {
    }

    public static int durationIndexBucket(long ts) {
        return (int)(ts / DURATION_INDEX_BUCKET_WINDOW_SECONDS / 1000000L);
    }

    static ByteBuffer toByteBuffer(String string) throws CharacterCodingException {
        return UTF8_ENCODER.get().encode(CharBuffer.wrap(string));
    }

    static String iso8601(long timestamp) {
        return DATE_FORMATTER.get().format(new Date(timestamp / 1000L));
    }

    static List<String> annotationKeys(Span span) {
        LinkedHashSet<String> annotationKeys = new LinkedHashSet<String>();
        for (Annotation a : span.annotations) {
            if (a.endpoint == null || a.endpoint.serviceName.isEmpty()) continue;
            annotationKeys.add(a.endpoint.serviceName + ":" + a.value);
        }
        for (BinaryAnnotation b : span.binaryAnnotations) {
            if (b.type != BinaryAnnotation.Type.STRING || b.endpoint == null || b.endpoint.serviceName.isEmpty()) continue;
            annotationKeys.add(b.endpoint.serviceName + ":" + b.key);
            annotationKeys.add(b.endpoint.serviceName + ":" + b.key + ":" + new String(b.value, Util.UTF_8));
        }
        return Util.sortedList(annotationKeys);
    }

    static List<String> annotationKeys(QueryRequest request) {
        LinkedHashSet<String> annotationKeys = new LinkedHashSet<String>();
        for (String string : request.annotations) {
            annotationKeys.add(request.serviceName + ":" + string);
        }
        for (Map.Entry entry : request.binaryAnnotations.entrySet()) {
            annotationKeys.add(request.serviceName + ":" + (String)entry.getKey() + ":" + (String)entry.getValue());
        }
        return Util.sortedList(annotationKeys);
    }

    static Function<Map<Long, Long>, Set<Long>> keyset() {
        return KeySet.INSTANCE;
    }

    static BoundStatement bindWithName(PreparedStatement prepared, String name) {
        return new NamedBoundStatement(prepared, name);
    }

    static Function<List<Map<Long, Long>>, Set<Long>> intersectKeySets() {
        return IntersectKeySets.INSTANCE;
    }

    static enum IntersectKeySets implements Function<List<Map<Object, ?>>, Set<Object>>
    {
        INSTANCE;


        public Set<Object> apply(List<Map<Object, ?>> input) {
            LinkedHashSet traceIds = Sets.newLinkedHashSet(input.get(0).keySet());
            for (int i = 1; i < input.size(); ++i) {
                traceIds.retainAll(input.get(i).keySet());
            }
            return traceIds;
        }
    }

    static enum KeySet implements Function<Map<Object, ?>, Set<Object>>
    {
        INSTANCE;


        public Set<Object> apply(Map<Object, ?> input) {
            return input.keySet();
        }
    }
}

