/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Schema {
    private static final Logger LOG = LoggerFactory.getLogger(Schema.class);
    private static final String SCHEMA = "/cassandra-schema-cql3.txt";

    private Schema() {
    }

    static Map<String, String> readMetadata(Session session) {
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        KeyspaceMetadata keyspaceMetadata = Schema.getKeyspaceMetadata(session.getLoggedKeyspace(), session.getCluster());
        Map replication = keyspaceMetadata.getReplication();
        if ("SimpleStrategy".equals(replication.get("class")) && "1".equals(replication.get("replication_factor"))) {
            LOG.warn("running with RF=1, this is not suitable for production. Optimal is 3+");
        }
        Map tracesCompaction = keyspaceMetadata.getTable("traces").getOptions().getCompaction();
        metadata.put("traces.compaction.class", (String)tracesCompaction.get("class"));
        return metadata;
    }

    private static KeyspaceMetadata getKeyspaceMetadata(String keyspace, Cluster cluster) {
        KeyspaceMetadata keyspaceMetadata = cluster.getMetadata().getKeyspace(keyspace);
        if (keyspaceMetadata == null) {
            throw new IllegalStateException(String.format("Cannot read keyspace metadata for give keyspace: %s and cluster: %s", keyspace, cluster.getClusterName()));
        }
        return keyspaceMetadata;
    }

    static void ensureExists(String keyspace, Session session) {
        try (InputStreamReader reader = new InputStreamReader(Schema.class.getResourceAsStream(SCHEMA));){
            for (String cmd : CharStreams.toString((Readable)reader).split(";")) {
                if ((cmd = cmd.trim().replace(" zipkin", " " + keyspace)).isEmpty()) continue;
                session.execute(cmd);
            }
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

