/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LatencyAwarePolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import com.google.common.net.HostAndPort;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import zipkin.storage.cassandra.CassandraStorage;
import zipkin.storage.cassandra.Schema;
import zipkin.storage.cassandra.ZipkinRetryPolicy;

public interface SessionFactory {
    public Session create(CassandraStorage var1);

    public static final class Default
    implements SessionFactory {
        @Override
        public Session create(CassandraStorage cassandra) {
            Closer closer = Closer.create();
            try {
                Cluster cluster = (Cluster)closer.register((Closeable)Default.buildCluster(cassandra));
                if (cassandra.ensureSchema) {
                    Session session = (Session)closer.register((Closeable)cluster.connect());
                    Schema.ensureExists(cassandra.keyspace, session);
                    session.execute("USE " + cassandra.keyspace);
                    return session;
                }
                return cluster.connect(cassandra.keyspace);
            }
            catch (RuntimeException e) {
                try {
                    closer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw e;
            }
        }

        static Cluster buildCluster(CassandraStorage cassandra) {
            Cluster.Builder builder = Cluster.builder();
            List<InetSocketAddress> contactPoints = Default.parseContactPoints(cassandra);
            int defaultPort = Default.findConnectPort(contactPoints);
            builder.addContactPointsWithPorts(contactPoints);
            builder.withPort(defaultPort);
            if (cassandra.username != null && cassandra.password != null) {
                builder.withCredentials(cassandra.username, cassandra.password);
            }
            builder.withRetryPolicy((RetryPolicy)ZipkinRetryPolicy.INSTANCE);
            builder.withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new LatencyAwarePolicy.Builder((LoadBalancingPolicy)(cassandra.localDc != null ? DCAwareRoundRobinPolicy.builder().withLocalDc(cassandra.localDc).build() : new RoundRobinPolicy())).build()));
            builder.withPoolingOptions(new PoolingOptions().setMaxConnectionsPerHost(HostDistance.LOCAL, cassandra.maxConnections));
            return builder.build();
        }

        static List<InetSocketAddress> parseContactPoints(CassandraStorage cassandra) {
            LinkedList<InetSocketAddress> result = new LinkedList<InetSocketAddress>();
            for (String contactPoint : cassandra.contactPoints.split(",")) {
                HostAndPort parsed = HostAndPort.fromString((String)contactPoint);
                result.add(new InetSocketAddress(parsed.getHostText(), parsed.getPortOrDefault(9042)));
            }
            return result;
        }

        static int findConnectPort(List<InetSocketAddress> contactPoints) {
            LinkedHashSet ports = Sets.newLinkedHashSet();
            for (InetSocketAddress contactPoint : contactPoints) {
                ports.add(contactPoint.getPort());
            }
            return ports.size() == 1 ? (Integer)ports.iterator().next() : 9042;
        }
    }
}

