/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin.Codec;
import zipkin.Span;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.internal.Nullable;
import zipkin.internal.Pair;
import zipkin.storage.cassandra.CassandraUtil;
import zipkin.storage.cassandra.CompositeIndexer;
import zipkin.storage.cassandra.DeduplicatingExecutor;
import zipkin.storage.cassandra.Schema;
import zipkin.storage.cassandra.TimestampCodec;
import zipkin.storage.guava.GuavaSpanConsumer;

final class CassandraSpanConsumer
implements GuavaSpanConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraSpanConsumer.class);
    private static final long WRITTEN_NAMES_TTL = Long.getLong("zipkin.store.cassandra.internal.writtenNamesTtl", 3600000L);
    private static final Function<Object, Void> TO_VOID = Functions.constant(null);
    private final Session session;
    private final TimestampCodec timestampCodec;
    @Deprecated
    private final int spanTtl;
    @Deprecated
    private final Integer indexTtl;
    private final PreparedStatement insertSpan;
    private final PreparedStatement insertServiceName;
    private final PreparedStatement insertSpanName;
    private final Schema.Metadata metadata;
    private final DeduplicatingExecutor deduplicatingExecutor;
    private final CompositeIndexer indexer;

    CassandraSpanConsumer(Session session, int bucketCount, int spanTtl, int indexTtl, @Nullable CacheBuilderSpec indexCacheSpec) {
        this.session = session;
        this.timestampCodec = new TimestampCodec(session);
        this.spanTtl = spanTtl;
        this.metadata = Schema.readMetadata(session);
        this.indexTtl = this.metadata.hasDefaultTtl ? null : Integer.valueOf(indexTtl);
        this.insertSpan = session.prepare(this.maybeUseTtl(QueryBuilder.insertInto((String)"traces").value("trace_id", (Object)QueryBuilder.bindMarker((String)"trace_id")).value("ts", (Object)QueryBuilder.bindMarker((String)"ts")).value("span_name", (Object)QueryBuilder.bindMarker((String)"span_name")).value("span", (Object)QueryBuilder.bindMarker((String)"span"))));
        this.insertServiceName = session.prepare(this.maybeUseTtl(QueryBuilder.insertInto((String)"service_names").value("service_name", (Object)QueryBuilder.bindMarker((String)"service_name"))));
        this.insertSpanName = session.prepare(this.maybeUseTtl(QueryBuilder.insertInto((String)"span_names").value("service_name", (Object)QueryBuilder.bindMarker((String)"service_name")).value("bucket", (Object)0).value("span_name", (Object)QueryBuilder.bindMarker((String)"span_name"))));
        this.deduplicatingExecutor = new DeduplicatingExecutor(session, WRITTEN_NAMES_TTL);
        this.indexer = new CompositeIndexer(session, indexCacheSpec, bucketCount, this.indexTtl);
    }

    private RegularStatement maybeUseTtl(Insert value) {
        return this.indexTtl == null ? value : value.using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker((String)"ttl_")));
    }

    public ListenableFuture<Void> accept(List<Span> rawSpans) {
        ImmutableSet.Builder futures = ImmutableSet.builder();
        ImmutableList.Builder spans = ImmutableList.builder();
        for (Span span : rawSpans) {
            Long timestamp = ApplyTimestampAndDuration.guessTimestamp((Span)span);
            spans.add((Object)span);
            futures.add(this.storeSpan(span.traceId, timestamp != null ? timestamp : 0L, String.format("%d_%d_%d", span.id, span.annotations.hashCode(), span.binaryAnnotations.hashCode()), ByteBuffer.wrap(Codec.THRIFT.writeSpan(span))));
            for (String serviceName : span.serviceNames()) {
                futures.add(this.storeServiceName(serviceName));
                if (span.name.isEmpty()) continue;
                futures.add(this.storeSpanName(serviceName, span.name));
            }
        }
        futures.addAll(this.indexer.index((List<Span>)spans.build()));
        return Futures.transform((ListenableFuture)Futures.allAsList((Iterable)futures.build()), TO_VOID);
    }

    ListenableFuture<?> storeSpan(long traceId, long timestamp, String key, ByteBuffer span) {
        try {
            if (0L == timestamp && this.metadata.compactionClass.contains("DateTieredCompactionStrategy")) {
                LOG.warn("Span {} in trace {} had no timestamp. If this happens a lot consider switching back to SizeTieredCompactionStrategy for {}.traces", new Object[]{key, traceId, this.session.getLoggedKeyspace()});
            }
            BoundStatement bound = CassandraUtil.bindWithName(this.insertSpan, "insert-span").setLong("trace_id", traceId).setBytesUnsafe("ts", this.timestampCodec.serialize(timestamp)).setString("span_name", key).setBytes("span", span);
            if (!this.metadata.hasDefaultTtl) {
                bound.setInt("ttl_", this.spanTtl);
            }
            return this.session.executeAsync((Statement)bound);
        }
        catch (RuntimeException ex) {
            return Futures.immediateFailedFuture((Throwable)ex);
        }
    }

    ListenableFuture<?> storeServiceName(String serviceName) {
        BoundStatement bound = CassandraUtil.bindWithName(this.insertServiceName, "insert-service-name").setString("service_name", serviceName);
        if (this.indexTtl != null) {
            bound.setInt("ttl_", this.indexTtl.intValue());
        }
        return this.deduplicatingExecutor.maybeExecuteAsync(bound, serviceName);
    }

    ListenableFuture<?> storeSpanName(String serviceName, String spanName) {
        BoundStatement bound = CassandraUtil.bindWithName(this.insertSpanName, "insert-span-name").setString("service_name", serviceName).setString("span_name", spanName);
        if (this.indexTtl != null) {
            bound.setInt("ttl_", this.indexTtl.intValue());
        }
        return this.deduplicatingExecutor.maybeExecuteAsync(bound, Pair.create((Object)serviceName, (Object)spanName));
    }

    @VisibleForTesting
    void clear() {
        this.indexer.clear();
        this.deduplicatingExecutor.clear();
    }
}

