/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin.Span;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.internal.Nullable;
import zipkin.internal.Pair;
import zipkin.storage.cassandra.CassandraUtil;
import zipkin.storage.cassandra.PartitionKeyToTraceId;
import zipkin.storage.cassandra.TimestampCodec;

final class Indexer {
    private static final Logger LOG = LoggerFactory.getLogger(Indexer.class);
    private final PreparedStatement prepared;
    private final TimestampCodec timestampCodec;
    private final String boundName;
    private final IndexSupport index;
    @Nullable
    private final Integer indexTtl;
    private final Session session;
    @Nullable
    private final ConcurrentMap<PartitionKeyToTraceId, Pair<Long>> sharedState;

    Indexer(Session session, @Nullable Integer indexTtl, @Nullable ConcurrentMap<PartitionKeyToTraceId, Pair<Long>> sharedState, IndexSupport index) {
        this.index = index;
        this.boundName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, index.getClass().getSimpleName());
        Insert insert = index.declarePartitionKey(QueryBuilder.insertInto((String)index.table()).value("ts", (Object)QueryBuilder.bindMarker((String)"ts")).value("trace_id", (Object)QueryBuilder.bindMarker((String)"trace_id")));
        if (indexTtl != null) {
            insert.using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker((String)"ttl_")));
        }
        this.prepared = session.prepare((RegularStatement)insert);
        this.indexTtl = indexTtl;
        this.session = session;
        this.timestampCodec = new TimestampCodec(session);
        this.sharedState = sharedState;
    }

    ImmutableSet<ListenableFuture<?>> index(List<Span> spans) {
        ImmutableSetMultimap<PartitionKeyToTraceId, Long> toInsert;
        ImmutableSetMultimap.Builder parsed = ImmutableSetMultimap.builder();
        for (Span span : spans) {
            Long timestamp = ApplyTimestampAndDuration.guessTimestamp((Span)span);
            if (timestamp == null) continue;
            for (String partitionKey : this.index.partitionKeys(span)) {
                parsed.put((Object)new PartitionKeyToTraceId(this.index.table(), partitionKey, span.traceId), (Object)(1000L * (timestamp / 1000L)));
            }
        }
        ImmutableSetMultimap<PartitionKeyToTraceId, Long> maybeInsert = parsed.build();
        if (this.sharedState == null) {
            toInsert = maybeInsert;
        } else {
            toInsert = Indexer.entriesThatIncreaseGap(this.sharedState, maybeInsert);
            if (maybeInsert.size() > toInsert.size() && LOG.isDebugEnabled()) {
                int delta = maybeInsert.size() - toInsert.size();
                LOG.debug("optimized out {}/{} inserts into {}", new Object[]{delta, maybeInsert.size(), this.index.table()});
            }
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Map.Entry entry : toInsert.entries()) {
            BoundStatement bound = CassandraUtil.bindWithName(this.prepared, this.boundName).setLong("trace_id", ((PartitionKeyToTraceId)entry.getKey()).traceId).setBytesUnsafe("ts", this.timestampCodec.serialize((Long)entry.getValue()));
            if (this.indexTtl != null) {
                bound.setInt("ttl_", this.indexTtl.intValue());
            }
            this.index.bindPartitionKey(bound, ((PartitionKeyToTraceId)entry.getKey()).partitionKey);
            result.add((Object)this.session.executeAsync((Statement)bound));
        }
        return result.build();
    }

    @VisibleForTesting
    static ImmutableSetMultimap<PartitionKeyToTraceId, Long> entriesThatIncreaseGap(ConcurrentMap<PartitionKeyToTraceId, Pair<Long>> sharedState, ImmutableSetMultimap<PartitionKeyToTraceId, Long> updates) {
        ImmutableSet.Builder toUpdate = ImmutableSet.builder();
        block0: for (Map.Entry input : updates.entries()) {
            Pair newRange;
            Pair<Long> oldRange;
            PartitionKeyToTraceId key = (PartitionKeyToTraceId)input.getKey();
            long timestamp = (Long)input.getValue();
            do {
                long last;
                if ((oldRange = (Pair<Long>)sharedState.get(key)) == null && (oldRange = sharedState.putIfAbsent(key, (Pair<Long>)Pair.create((Object)timestamp, (Object)timestamp))) == null) {
                    toUpdate.add((Object)key);
                    continue block0;
                }
                long first = timestamp < (Long)oldRange._1 ? timestamp : (Long)oldRange._1;
                long l = last = timestamp > (Long)oldRange._2 ? timestamp : (Long)oldRange._2;
                newRange = Pair.create((Object)first, (Object)last);
                if (oldRange.equals((Object)newRange)) continue block0;
            } while (!sharedState.replace(key, oldRange, (Pair<Long>)newRange));
            toUpdate.add((Object)key);
        }
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (PartitionKeyToTraceId needsUpdate : toUpdate.build()) {
            Pair firstLast = (Pair)sharedState.get(needsUpdate);
            if (updates.containsEntry((Object)needsUpdate, firstLast._1)) {
                result.put((Object)needsUpdate, firstLast._1);
            }
            if (!updates.containsEntry((Object)needsUpdate, firstLast._2)) continue;
            result.put((Object)needsUpdate, firstLast._2);
        }
        return result.build();
    }

    static class Factory {
        private final Session session;
        private final Integer indexTtl;
        private final ConcurrentMap<PartitionKeyToTraceId, Pair<Long>> sharedState;

        public Factory(Session session, @Nullable Integer indexTtl, @Nullable ConcurrentMap<PartitionKeyToTraceId, Pair<Long>> sharedState) {
            this.session = session;
            this.indexTtl = indexTtl;
            this.sharedState = sharedState;
        }

        Indexer create(IndexSupport index) {
            return new Indexer(this.session, this.indexTtl, this.sharedState, index);
        }
    }

    static interface IndexSupport {
        public String table();

        public Insert declarePartitionKey(Insert var1);

        public BoundStatement bindPartitionKey(BoundStatement var1, String var2);

        public Set<String> partitionKeys(Span var1);
    }
}

