/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.nio.charset.CharacterCodingException;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import zipkin.Span;
import zipkin.storage.cassandra.CassandraUtil;
import zipkin.storage.cassandra.Indexer;

final class InsertTraceIdByAnnotation
implements Indexer.IndexSupport {
    private static final ThreadLocalRandom RAND = ThreadLocalRandom.current();
    private final int bucketCount;

    InsertTraceIdByAnnotation(int bucketCount) {
        this.bucketCount = bucketCount;
    }

    @Override
    public String table() {
        return "annotations_index";
    }

    @Override
    public Insert declarePartitionKey(Insert insert) {
        return insert.value("annotation", (Object)QueryBuilder.bindMarker((String)"annotation")).value("bucket", (Object)QueryBuilder.bindMarker((String)"bucket"));
    }

    @Override
    public BoundStatement bindPartitionKey(BoundStatement bound, String partitionKey) {
        try {
            return bound.setInt("bucket", RAND.nextInt(this.bucketCount)).setBytes("annotation", CassandraUtil.toByteBuffer(partitionKey));
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Set<String> partitionKeys(Span span) {
        return CassandraUtil.annotationKeys(span);
    }
}

