/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Constants;
import zipkin.Span;
import zipkin.internal.Util;
import zipkin.storage.QueryRequest;
import zipkin.storage.cassandra.NamedBoundStatement;

final class CassandraUtil {
    static final int LONGEST_VALUE_TO_INDEX = 256;
    private static final ThreadLocal<CharsetEncoder> UTF8_ENCODER = new ThreadLocal<CharsetEncoder>(){

        @Override
        protected CharsetEncoder initialValue() {
            return Util.UTF_8.newEncoder();
        }
    };

    CassandraUtil() {
    }

    static ByteBuffer toByteBuffer(String string) throws CharacterCodingException {
        return UTF8_ENCODER.get().encode(CharBuffer.wrap(string));
    }

    static Set<String> annotationKeys(Span span) {
        LinkedHashSet<String> annotationKeys = new LinkedHashSet<String>();
        for (Annotation a : span.annotations) {
            if (Constants.CORE_ANNOTATIONS.contains(a.value) || a.endpoint == null || a.endpoint.serviceName.isEmpty()) continue;
            annotationKeys.add(a.endpoint.serviceName + ":" + a.value);
        }
        for (BinaryAnnotation b : span.binaryAnnotations) {
            String value;
            if (b.type != BinaryAnnotation.Type.STRING || b.endpoint == null || b.endpoint.serviceName.isEmpty() || b.value.length > 1024 || (value = new String(b.value, Util.UTF_8)).length() > 256) continue;
            annotationKeys.add(b.endpoint.serviceName + ":" + b.key);
            annotationKeys.add(b.endpoint.serviceName + ":" + b.key + ":" + new String(b.value, Util.UTF_8));
        }
        return annotationKeys;
    }

    static List<String> annotationKeys(QueryRequest request) {
        if (request.annotations.isEmpty() && request.binaryAnnotations.isEmpty()) {
            return Collections.emptyList();
        }
        Util.checkArgument((request.serviceName != null ? 1 : 0) != 0, (String)"serviceName needed with annotation query", (Object[])new Object[0]);
        LinkedHashSet<String> annotationKeys = new LinkedHashSet<String>();
        for (String string : request.annotations) {
            annotationKeys.add(request.serviceName + ":" + string);
        }
        for (Map.Entry entry : request.binaryAnnotations.entrySet()) {
            annotationKeys.add(request.serviceName + ":" + (String)entry.getKey() + ":" + (String)entry.getValue());
        }
        return Util.sortedList(annotationKeys);
    }

    static Function<Map<Long, Long>, Set<Long>> keyset() {
        return KeySet.INSTANCE;
    }

    static BoundStatement bindWithName(PreparedStatement prepared, String name) {
        return new NamedBoundStatement(prepared, name);
    }

    static Function<List<Map<Long, Long>>, Set<Long>> intersectKeySets() {
        return IntersectKeySets.INSTANCE;
    }

    static enum IntersectKeySets implements Function<List<Map<Object, ?>>, Set<Object>>
    {
        INSTANCE;


        public Set<Object> apply(@Nullable List<Map<Object, ?>> input) {
            LinkedHashSet traceIds = Sets.newLinkedHashSet(input.get(0).keySet());
            for (int i = 1; i < input.size(); ++i) {
                traceIds.retainAll(input.get(i).keySet());
            }
            return traceIds;
        }
    }

    static enum KeySet implements Function<Map<Object, ?>, Set<Object>>
    {
        INSTANCE;


        public Set<Object> apply(@Nullable Map<Object, ?> input) {
            return input.keySet();
        }
    }
}

