/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra;

import com.datastax.driver.core.Session;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import zipkin.Span;
import zipkin.internal.Pair;
import zipkin.storage.cassandra.Indexer;
import zipkin.storage.cassandra.InsertTraceIdByAnnotation;
import zipkin.storage.cassandra.InsertTraceIdByServiceName;
import zipkin.storage.cassandra.InsertTraceIdBySpanName;
import zipkin.storage.cassandra.PartitionKeyToTraceId;

final class CompositeIndexer {
    private final Set<Indexer> indexers;
    private final ConcurrentMap<PartitionKeyToTraceId, Pair<Long>> sharedState;

    CompositeIndexer(Session session, CacheBuilderSpec spec, int bucketCount, @Nullable Integer indexTtl) {
        this.sharedState = spec == null ? null : CacheBuilder.from((CacheBuilderSpec)spec).build().asMap();
        Indexer.Factory factory = new Indexer.Factory(session, indexTtl, this.sharedState);
        this.indexers = ImmutableSet.of((Object)factory.create(new InsertTraceIdByServiceName(bucketCount)), (Object)factory.create(new InsertTraceIdBySpanName()), (Object)factory.create(new InsertTraceIdByAnnotation(bucketCount)));
    }

    ImmutableSet<ListenableFuture<?>> index(List<Span> spans) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Indexer optimizer : this.indexers) {
            result.addAll(optimizer.index(spans));
        }
        return result.build();
    }

    public void clear() {
        this.sharedState.clear();
    }
}

