/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import zipkin.internal.Util;

class DeduplicatingExecutor {
    private final Session session;
    private final LoadingCache<BoundStatementKey, ListenableFuture<Void>> cache;

    DeduplicatingExecutor(Session session, long ttl) {
        this.session = session;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(ttl, TimeUnit.MILLISECONDS).ticker(new Ticker(){

            public long read() {
                return DeduplicatingExecutor.this.nanoTime();
            }
        }).build((CacheLoader)new CacheLoader<BoundStatementKey, ListenableFuture<Void>>(){

            public ListenableFuture<Void> load(final BoundStatementKey key) {
                ListenableFuture<?> cassandraFuture = DeduplicatingExecutor.this.executeAsync(key.statement);
                final SettableFuture disconnectedFuture = SettableFuture.create();
                Futures.addCallback(cassandraFuture, (FutureCallback)new FutureCallback<Object>(){

                    public void onSuccess(@Nullable Object result) {
                        disconnectedFuture.set(null);
                    }

                    public void onFailure(Throwable t) {
                        DeduplicatingExecutor.this.cache.invalidate((Object)key);
                        disconnectedFuture.setException(t);
                    }
                });
                return disconnectedFuture;
            }
        });
    }

    ListenableFuture<Void> maybeExecuteAsync(BoundStatement statement, Object key) {
        BoundStatementKey cacheKey = new BoundStatementKey(statement, key);
        try {
            ListenableFuture result = (ListenableFuture)this.cache.get((Object)new BoundStatementKey(statement, key));
            if (result.isDone()) {
                result.get();
            }
            return result;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            this.cache.invalidate((Object)cacheKey);
            return Futures.immediateFailedFuture((Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AssertionError();
        }
    }

    long nanoTime() {
        return System.nanoTime();
    }

    @VisibleForTesting
    ListenableFuture<?> executeAsync(BoundStatement statement) {
        return this.session.executeAsync((Statement)statement);
    }

    @VisibleForTesting
    void clear() {
        this.cache.invalidateAll();
    }

    static final class BoundStatementKey {
        final BoundStatement statement;
        final Object key;

        BoundStatementKey(BoundStatement statement, Object key) {
            this.statement = (BoundStatement)Util.checkNotNull((Object)statement, (String)"statement");
            this.key = Util.checkNotNull((Object)key, (String)"key");
        }

        public String toString() {
            return "(" + this.key + ", " + this.statement + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof BoundStatementKey) {
                return this.key.equals(((BoundStatementKey)o).key);
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

