/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import zipkin.Span;
import zipkin.storage.cassandra.Indexer;

final class InsertTraceIdByServiceName
implements Indexer.IndexSupport {
    private static final ThreadLocalRandom RAND = ThreadLocalRandom.current();
    private final int bucketCount;

    InsertTraceIdByServiceName(int bucketCount) {
        this.bucketCount = bucketCount;
    }

    @Override
    public String table() {
        return "service_name_index";
    }

    @Override
    public Insert declarePartitionKey(Insert insert) {
        return insert.value("service_name", (Object)QueryBuilder.bindMarker((String)"service_name")).value("bucket", (Object)QueryBuilder.bindMarker((String)"bucket"));
    }

    @Override
    public BoundStatement bindPartitionKey(BoundStatement bound, String partitionKey) {
        return bound.setInt("bucket", RAND.nextInt(this.bucketCount)).setString("service_name", partitionKey);
    }

    @Override
    public Set<String> partitionKeys(Span span) {
        return span.serviceNames();
    }
}

