/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin.internal.Util;

final class Schema {
    private static final Logger LOG = LoggerFactory.getLogger(Schema.class);
    private static final String SCHEMA = "/cassandra-schema-cql3.txt";
    private static final String UPGRADE_1 = "/cassandra-schema-cql3-upgrade-1.txt";

    private Schema() {
    }

    static Metadata readMetadata(Session session) {
        KeyspaceMetadata keyspaceMetadata = Schema.getKeyspaceMetadata(session);
        Map replication = keyspaceMetadata.getReplication();
        if ("SimpleStrategy".equals(replication.get("class")) && "1".equals(replication.get("replication_factor"))) {
            LOG.warn("running with RF=1, this is not suitable for production. Optimal is 3+");
        }
        String compactionClass = (String)keyspaceMetadata.getTable("traces").getOptions().getCompaction().get("class");
        boolean hasDefaultTtl = Schema.hasUpgrade1_defaultTtl(keyspaceMetadata);
        if (!hasDefaultTtl) {
            LOG.warn("schema lacks default ttls: apply {}, or set CassandraStorage.ensureSchema=true", (Object)UPGRADE_1);
        }
        return new Metadata(compactionClass, hasDefaultTtl);
    }

    static KeyspaceMetadata getKeyspaceMetadata(Session session) {
        String keyspace = session.getLoggedKeyspace();
        Cluster cluster = session.getCluster();
        KeyspaceMetadata keyspaceMetadata = cluster.getMetadata().getKeyspace(keyspace);
        if (keyspaceMetadata == null) {
            throw new IllegalStateException(String.format("Cannot read keyspace metadata for give keyspace: %s and cluster: %s", keyspace, cluster.getClusterName()));
        }
        return keyspaceMetadata;
    }

    static void ensureExists(String keyspace, Session session) {
        KeyspaceMetadata keyspaceMetadata = session.getCluster().getMetadata().getKeyspace(keyspace);
        if (keyspaceMetadata == null || keyspaceMetadata.getTable("traces") == null) {
            LOG.info("Installing schema {}", (Object)SCHEMA);
            Schema.applyCqlFile(keyspace, session, SCHEMA);
            keyspaceMetadata = session.getCluster().getMetadata().getKeyspace(keyspace);
        }
        if (!Schema.hasUpgrade1_defaultTtl(keyspaceMetadata)) {
            LOG.info("Upgrading schema {}", (Object)UPGRADE_1);
            Schema.applyCqlFile(keyspace, session, UPGRADE_1);
        }
    }

    static boolean hasUpgrade1_defaultTtl(KeyspaceMetadata keyspaceMetadata) {
        return keyspaceMetadata.getTable("traces").getOptions().getDefaultTimeToLive() > 0;
    }

    static void applyCqlFile(String keyspace, Session session, String resource) {
        try (InputStreamReader reader = new InputStreamReader(Schema.class.getResourceAsStream(resource), Util.UTF_8);){
            for (String cmd : CharStreams.toString((Readable)reader).split(";")) {
                if ((cmd = cmd.trim().replace(" zipkin", " " + keyspace)).isEmpty()) continue;
                session.execute(cmd);
            }
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    static final class Metadata {
        final String compactionClass;
        final boolean hasDefaultTtl;

        Metadata(String compactionClass, boolean hasDefaultTtl) {
            this.compactionClass = compactionClass;
            this.hasDefaultTtl = hasDefaultTtl;
        }
    }
}

