/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra;

import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TypeCodec;
import java.nio.ByteBuffer;

final class TimestampCodec {
    private final ProtocolVersion protocolVersion;

    TimestampCodec(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public TimestampCodec(Session session) {
        this(session.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion());
    }

    public ByteBuffer serialize(long timestamp) {
        return TypeCodec.bigint().serialize(Long.valueOf(timestamp / 1000L), this.protocolVersion);
    }

    public long deserialize(Row row, String name) {
        return 1000L * TypeCodec.bigint().deserialize(row.getBytesUnsafe(name), this.protocolVersion);
    }
}

