/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra;

import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import zipkin.Component;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.storage.StorageComponent;
import zipkin.storage.cassandra.CassandraSpanConsumer;
import zipkin.storage.cassandra.CassandraSpanStore;
import zipkin.storage.cassandra.LazySession;
import zipkin.storage.cassandra.SessionFactory;
import zipkin.storage.guava.LazyGuavaStorageComponent;

public final class CassandraStorage
extends LazyGuavaStorageComponent<CassandraSpanStore, CassandraSpanConsumer> {
    final int maxTraceCols;
    @Deprecated
    final int indexTtl;
    @Deprecated
    final int spanTtl;
    final int bucketCount;
    final String contactPoints;
    final int maxConnections;
    final String localDc;
    final String username;
    final String password;
    final boolean ensureSchema;
    final boolean useSsl;
    final String keyspace;
    final CacheBuilderSpec indexCacheSpec;
    final int indexFetchMultiplier;
    final boolean strictTraceId;
    final LazySession session;

    public static Builder builder() {
        return new Builder();
    }

    CassandraStorage(Builder builder) {
        this.contactPoints = builder.contactPoints;
        this.maxConnections = builder.maxConnections;
        this.localDc = builder.localDc;
        this.username = builder.username;
        this.password = builder.password;
        this.ensureSchema = builder.ensureSchema;
        this.useSsl = builder.useSsl;
        this.keyspace = builder.keyspace;
        this.maxTraceCols = builder.maxTraceCols;
        this.strictTraceId = builder.strictTraceId;
        this.indexTtl = builder.indexTtl;
        this.spanTtl = builder.spanTtl;
        this.bucketCount = builder.bucketCount;
        this.session = new LazySession(builder.sessionFactory, this);
        this.indexCacheSpec = builder.indexCacheMax == 0 ? null : CacheBuilderSpec.parse((String)("maximumSize=" + builder.indexCacheMax + ",expireAfterWrite=" + builder.indexCacheTtl + "s"));
        this.indexFetchMultiplier = builder.indexFetchMultiplier;
    }

    public Session session() {
        return (Session)this.session.get();
    }

    protected CassandraSpanStore computeGuavaSpanStore() {
        return new CassandraSpanStore((Session)this.session.get(), this.bucketCount, this.maxTraceCols, this.indexFetchMultiplier, this.strictTraceId);
    }

    protected CassandraSpanConsumer computeGuavaSpanConsumer() {
        return new CassandraSpanConsumer((Session)this.session.get(), this.bucketCount, this.spanTtl, this.indexTtl, this.indexCacheSpec);
    }

    public Component.CheckResult check() {
        try {
            ((Session)this.session.get()).execute((Statement)QueryBuilder.select((String[])new String[]{"trace_id"}).from("traces").limit(1));
        }
        catch (RuntimeException e) {
            return Component.CheckResult.failed((Exception)e);
        }
        return Component.CheckResult.OK;
    }

    public void close() throws IOException {
        this.session.close();
    }

    @VisibleForTesting
    void clear() {
        ((CassandraSpanConsumer)this.guavaSpanConsumer()).clear();
        ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
        for (String cf : ImmutableList.of((Object)"traces", (Object)"dependencies", (Object)"service_names", (Object)"span_names", (Object)"service_name_index", (Object)"service_span_name_index", (Object)"annotations_index")) {
            futures.add(((Session)this.session.get()).executeAsync(String.format("TRUNCATE %s", cf)));
        }
        Futures.getUnchecked((Future)Futures.allAsList(futures));
    }

    public static final class Builder
    implements StorageComponent.Builder {
        boolean strictTraceId = true;
        String keyspace = "zipkin";
        String contactPoints = "localhost";
        String localDc;
        int maxConnections = 8;
        boolean ensureSchema = true;
        boolean useSsl = false;
        String username;
        String password;
        int maxTraceCols = 100000;
        int indexCacheMax = 100000;
        int indexCacheTtl = 60;
        int indexFetchMultiplier = 3;
        int bucketCount = 10;
        int spanTtl = (int)TimeUnit.DAYS.toSeconds(7L);
        int indexTtl = (int)TimeUnit.DAYS.toSeconds(3L);
        SessionFactory sessionFactory = new SessionFactory.Default();

        public Builder strictTraceId(boolean strictTraceId) {
            this.strictTraceId = strictTraceId;
            return this;
        }

        public Builder sessionFactory(SessionFactory sessionFactory) {
            this.sessionFactory = (SessionFactory)Util.checkNotNull((Object)sessionFactory, (String)"sessionFactory");
            return this;
        }

        public Builder keyspace(String keyspace) {
            this.keyspace = (String)Util.checkNotNull((Object)keyspace, (String)"keyspace");
            return this;
        }

        public Builder contactPoints(String contactPoints) {
            this.contactPoints = (String)Util.checkNotNull((Object)contactPoints, (String)"contactPoints");
            return this;
        }

        public Builder localDc(@Nullable String localDc) {
            this.localDc = localDc;
            return this;
        }

        public Builder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder ensureSchema(boolean ensureSchema) {
            this.ensureSchema = ensureSchema;
            return this;
        }

        public Builder useSsl(boolean useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder username(@Nullable String username) {
            this.username = username;
            return this;
        }

        public Builder password(@Nullable String password) {
            this.password = password;
            return this;
        }

        public Builder maxTraceCols(int maxTraceCols) {
            this.maxTraceCols = maxTraceCols;
            return this;
        }

        @Deprecated
        public Builder spanTtl(int spanTtl) {
            this.spanTtl = spanTtl;
            return this;
        }

        @Deprecated
        public Builder indexTtl(int indexTtl) {
            this.indexTtl = indexTtl;
            return this;
        }

        public Builder indexCacheMax(int indexCacheMax) {
            this.indexCacheMax = indexCacheMax;
            return this;
        }

        public Builder indexCacheTtl(int indexCacheTtl) {
            this.indexCacheTtl = indexCacheTtl;
            return this;
        }

        public Builder indexFetchMultiplier(int indexFetchMultiplier) {
            this.indexFetchMultiplier = indexFetchMultiplier;
            return this;
        }

        public CassandraStorage build() {
            return new CassandraStorage(this);
        }

        Builder() {
        }
    }
}

