/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import zipkin.Span;
import zipkin.storage.cassandra.Indexer;

final class InsertTraceIdBySpanName
implements Indexer.IndexSupport {
    InsertTraceIdBySpanName() {
    }

    @Override
    public String table() {
        return "service_span_name_index";
    }

    @Override
    public Insert declarePartitionKey(Insert insert) {
        return insert.value("service_span_name", (Object)QueryBuilder.bindMarker((String)"service_span_name"));
    }

    @Override
    public BoundStatement bindPartitionKey(BoundStatement bound, String partitionKey) {
        return bound.setString("service_span_name", partitionKey);
    }

    @Override
    public Set<String> partitionKeys(Span span) {
        if (span.name.isEmpty()) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (String serviceName : span.serviceNames()) {
            result.add((Object)(serviceName + "." + span.name));
        }
        return result.build();
    }
}

