/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.cassandra;

import zipkin.internal.Util;

final class PartitionKeyToTraceId {
    final String table;
    final String partitionKey;
    final long traceId;

    PartitionKeyToTraceId(String table, String partitionKey, long traceId) {
        this.table = table;
        this.partitionKey = partitionKey;
        this.traceId = traceId;
    }

    public String toString() {
        return "(" + this.table + "," + this.partitionKey + "," + Util.toLowerHex((long)this.traceId) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PartitionKeyToTraceId) {
            PartitionKeyToTraceId that = (PartitionKeyToTraceId)o;
            return this.table.equals(that.table) && this.partitionKey.equals(that.partitionKey) && this.traceId == that.traceId;
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.table.hashCode();
        h *= 1000003;
        h ^= this.partitionKey.hashCode();
        h *= 1000003;
        h ^= (int)((long)h ^ (this.traceId >>> 32 ^ this.traceId));
        return h;
    }
}

