/*
 * Decompiled with CFR 0.152.
 */
package zipkin.elasticsearch;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.client.Client;
import zipkin.DependencyLink;
import zipkin.elasticsearch.ElasticsearchSpanConsumer;
import zipkin.elasticsearch.ElasticsearchSpanStore;
import zipkin.elasticsearch.IndexNameFormatter;
import zipkin.elasticsearch.LazyClient;
import zipkin.internal.Util;
import zipkin.spanstore.guava.LazyGuavaStorageComponent;

public final class ElasticsearchStorage
extends LazyGuavaStorageComponent<ElasticsearchSpanStore, ElasticsearchSpanConsumer> {
    @VisibleForTesting
    static boolean FLUSH_ON_WRITES;
    private final LazyClient lazyClient;
    private final IndexNameFormatter indexNameFormatter;

    public static Builder builder() {
        return new Builder();
    }

    ElasticsearchStorage(Builder builder) {
        this.lazyClient = new LazyClient(builder);
        this.indexNameFormatter = new IndexNameFormatter(builder.index);
    }

    protected ElasticsearchSpanStore computeGuavaSpanStore() {
        return new ElasticsearchSpanStore((Client)this.lazyClient.get(), this.indexNameFormatter);
    }

    protected ElasticsearchSpanConsumer computeGuavaSpanConsumer() {
        return new ElasticsearchSpanConsumer((Client)this.lazyClient.get(), this.indexNameFormatter);
    }

    @VisibleForTesting
    void writeDependencyLinks(List<DependencyLink> links, long timestampMillis) {
        long midnight = Util.midnightUTC((long)timestampMillis);
        BulkRequestBuilder request = ((Client)this.lazyClient.get()).prepareBulk();
        for (DependencyLink link : links) {
            request.add(((Client)this.lazyClient.get()).prepareIndex(this.indexNameFormatter.indexNameForTimestamp(midnight), "dependencylink").setSource("parent", (Object)link.parent, "child", (Object)link.child, "parent_child", (Object)(link.parent + "|" + link.child), "callCount", (Object)link.callCount));
        }
        request.execute().actionGet();
        ((Client)this.lazyClient.get()).admin().indices().flush(new FlushRequest()).actionGet();
    }

    @VisibleForTesting
    void clear() {
        ((Client)this.lazyClient.get()).admin().indices().delete(new DeleteIndexRequest(this.indexNameFormatter.catchAll())).actionGet();
        ((Client)this.lazyClient.get()).admin().indices().flush(new FlushRequest()).actionGet();
    }

    public void close() {
        this.lazyClient.close();
    }

    public String toString() {
        return this.lazyClient.toString();
    }

    public static final class Builder {
        String cluster = "elasticsearch";
        List<String> hosts = Collections.singletonList("localhost:9300");
        String index = "zipkin";

        public Builder cluster(String cluster) {
            this.cluster = (String)Util.checkNotNull((Object)cluster, (String)"cluster");
            return this;
        }

        public Builder hosts(List<String> hosts) {
            this.hosts = (List)Util.checkNotNull(hosts, (String)"hosts");
            return this;
        }

        public Builder index(String index) {
            this.index = (String)Util.checkNotNull((Object)index, (String)"index");
            return this;
        }

        public ElasticsearchStorage build() {
            return new ElasticsearchStorage(this);
        }

        Builder() {
        }
    }
}

