/*
 * Decompiled with CFR 0.152.
 */
package zipkin.elasticsearch;

import com.google.common.base.Joiner;
import com.google.common.io.Resources;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import zipkin.elasticsearch.ElasticsearchStorage;
import zipkin.internal.LazyCloseable;

final class LazyClient
extends LazyCloseable<Client> {
    private final String clusterName;
    private final List<String> hosts;
    private final String indexTemplate;

    LazyClient(ElasticsearchStorage.Builder builder) {
        this.clusterName = builder.cluster;
        this.hosts = builder.hosts;
        try {
            this.indexTemplate = Resources.toString((URL)Resources.getResource((String)"zipkin/elasticsearch/zipkin_template.json"), (Charset)StandardCharsets.UTF_8).replace("${__INDEX__}", builder.index);
        }
        catch (IOException e) {
            throw new AssertionError("Error reading jar resource, shouldn't happen.", e);
        }
    }

    protected Client compute() {
        Settings settings = Settings.builder().put("cluster.name", this.clusterName).put("lazyClient.transport.sniff", true).build();
        TransportClient client = TransportClient.builder().settings(settings).build();
        for (String host : this.hosts) {
            HostAndPort hostAndPort = HostAndPort.fromString((String)host);
            try {
                client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(hostAndPort.getHostText()), hostAndPort.getPort()));
            }
            catch (UnknownHostException e) {}
        }
        LazyClient.checkForIndexTemplate((Client)client, this.indexTemplate);
        return client;
    }

    static void checkForIndexTemplate(Client client, String indexTemplate) {
        GetIndexTemplatesResponse existingTemplates = (GetIndexTemplatesResponse)client.admin().indices().getTemplates(new GetIndexTemplatesRequest(new String[]{"zipkin_template"})).actionGet();
        if (!existingTemplates.getIndexTemplates().isEmpty()) {
            return;
        }
        client.admin().indices().putTemplate(new PutIndexTemplateRequest("zipkin_template").source(indexTemplate)).actionGet();
    }

    public String toString() {
        StringBuilder json = new StringBuilder("{\"clusterName\": \"").append(this.clusterName).append("\"");
        json.append(", \"hosts\": [\"").append(Joiner.on((String)"\", \"").join(this.hosts)).append("\"]");
        return json.append("}").toString();
    }

    public void close() {
        Client maybeNull = (Client)this.maybeNull();
        if (maybeNull != null) {
            maybeNull.close();
        }
    }
}

