/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;
import zipkin.Codec;
import zipkin.Span;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.storage.elasticsearch.ElasticFutures;
import zipkin.storage.elasticsearch.ElasticsearchStorage;
import zipkin.storage.elasticsearch.IndexNameFormatter;
import zipkin.storage.guava.GuavaSpanConsumer;

final class ElasticsearchSpanConsumer
implements GuavaSpanConsumer {
    private static final Function<Object, Void> TO_VOID = Functions.constant(null);
    private final Client client;
    private final IndexNameFormatter indexNameFormatter;

    ElasticsearchSpanConsumer(Client client, IndexNameFormatter indexNameFormatter) {
        this.client = client;
        this.indexNameFormatter = indexNameFormatter;
    }

    public ListenableFuture<Void> accept(List<Span> spans) {
        BulkRequestBuilder request = this.client.prepareBulk();
        for (Span span : spans) {
            request.add(this.createSpanIndexRequest(ApplyTimestampAndDuration.apply((Span)span)));
        }
        ListenableFuture future = ElasticFutures.toGuava(request.execute());
        if (ElasticsearchStorage.FLUSH_ON_WRITES) {
            future = Futures.transform(future, (AsyncFunction)new AsyncFunction(){

                public ListenableFuture apply(Object input) {
                    return ElasticFutures.toGuava(ElasticsearchSpanConsumer.this.client.admin().indices().prepareFlush(new String[]{ElasticsearchSpanConsumer.this.indexNameFormatter.catchAll()}).execute());
                }
            });
        }
        return Futures.transform(future, TO_VOID);
    }

    private IndexRequestBuilder createSpanIndexRequest(Span span) {
        long indexTimestampMillis = span.timestamp != null ? TimeUnit.MICROSECONDS.toMillis(span.timestamp) : System.currentTimeMillis();
        String spanIndex = this.indexNameFormatter.indexNameForTimestamp(indexTimestampMillis);
        return this.client.prepareIndex(spanIndex, "span").setSource(Codec.JSON.writeSpan(span));
    }
}

