/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import zipkin.Component;
import zipkin.DependencyLink;
import zipkin.internal.Util;
import zipkin.storage.elasticsearch.ElasticsearchSpanConsumer;
import zipkin.storage.elasticsearch.ElasticsearchSpanStore;
import zipkin.storage.elasticsearch.IndexNameFormatter;
import zipkin.storage.elasticsearch.LazyClient;
import zipkin.storage.guava.LazyGuavaStorageComponent;

public final class ElasticsearchStorage
extends LazyGuavaStorageComponent<ElasticsearchSpanStore, ElasticsearchSpanConsumer> {
    @VisibleForTesting
    static boolean FLUSH_ON_WRITES;
    private final LazyClient lazyClient;
    private final IndexNameFormatter indexNameFormatter;

    public static Builder builder() {
        return new Builder();
    }

    ElasticsearchStorage(Builder builder) {
        this.lazyClient = new LazyClient(builder);
        this.indexNameFormatter = new IndexNameFormatter(builder.index);
    }

    public Client client() {
        return (Client)this.lazyClient.get();
    }

    protected ElasticsearchSpanStore computeGuavaSpanStore() {
        return new ElasticsearchSpanStore((Client)this.lazyClient.get(), this.indexNameFormatter);
    }

    protected ElasticsearchSpanConsumer computeGuavaSpanConsumer() {
        return new ElasticsearchSpanConsumer((Client)this.lazyClient.get(), this.indexNameFormatter);
    }

    @VisibleForTesting
    void writeDependencyLinks(List<DependencyLink> links, long timestampMillis) {
        long midnight = Util.midnightUTC((long)timestampMillis);
        BulkRequestBuilder request = ((Client)this.lazyClient.get()).prepareBulk();
        for (DependencyLink link : links) {
            request.add(((Client)this.lazyClient.get()).prepareIndex(this.indexNameFormatter.indexNameForTimestamp(midnight), "dependencylink").setSource("parent", (Object)link.parent, "child", (Object)link.child, "parent_child", (Object)(link.parent + "|" + link.child), "callCount", (Object)link.callCount));
        }
        request.execute().actionGet();
        ((Client)this.lazyClient.get()).admin().indices().flush(new FlushRequest()).actionGet();
    }

    @VisibleForTesting
    void clear() {
        ((Client)this.lazyClient.get()).admin().indices().delete(new DeleteIndexRequest(this.indexNameFormatter.catchAll())).actionGet();
        ((Client)this.lazyClient.get()).admin().indices().flush(new FlushRequest()).actionGet();
    }

    public Component.CheckResult check() {
        try {
            ClusterHealthResponse health = (ClusterHealthResponse)Futures.getUnchecked((Future)((Client)this.lazyClient.get()).admin().cluster().prepareHealth(new String[]{this.indexNameFormatter.catchAll()}).execute());
            Preconditions.checkState((health.getStatus() != ClusterHealthStatus.RED ? 1 : 0) != 0, (Object)"Health status is RED");
        }
        catch (RuntimeException e) {
            return Component.CheckResult.failed((Exception)e);
        }
        return Component.CheckResult.OK;
    }

    public void close() {
        this.lazyClient.close();
    }

    public String toString() {
        return this.lazyClient.toString();
    }

    public static final class Builder {
        String cluster = "elasticsearch";
        List<String> hosts = Collections.singletonList("localhost:9300");
        String index = "zipkin";

        public Builder cluster(String cluster) {
            this.cluster = (String)Util.checkNotNull((Object)cluster, (String)"cluster");
            return this;
        }

        public Builder hosts(List<String> hosts) {
            this.hosts = (List)Util.checkNotNull(hosts, (String)"hosts");
            return this;
        }

        public Builder index(String index) {
            this.index = (String)Util.checkNotNull((Object)index, (String)"index");
            return this;
        }

        public ElasticsearchStorage build() {
            return new ElasticsearchStorage(this);
        }

        Builder() {
        }
    }
}

