/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;
import zipkin.Codec;
import zipkin.Span;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.storage.elasticsearch.ElasticFutures;
import zipkin.storage.elasticsearch.ElasticsearchStorage;
import zipkin.storage.elasticsearch.IndexNameFormatter;
import zipkin.storage.guava.GuavaSpanConsumer;

final class ElasticsearchSpanConsumer
implements GuavaSpanConsumer {
    private static final byte[] TIMESTAMP_MILLIS_PREFIX = "{\"timestamp_millis\":".getBytes();
    private static final Function<Object, Void> TO_VOID = Functions.constant(null);
    private final Client client;
    private final IndexNameFormatter indexNameFormatter;

    ElasticsearchSpanConsumer(Client client, IndexNameFormatter indexNameFormatter) {
        this.client = client;
        this.indexNameFormatter = indexNameFormatter;
    }

    public ListenableFuture<Void> accept(List<Span> spans) {
        ListenableFuture future;
        if (spans.isEmpty()) {
            return Futures.immediateFuture(null);
        }
        if (spans.size() == 1) {
            future = ElasticFutures.toGuava(this.createSpanIndexRequest(spans.get(0)).execute());
        } else {
            BulkRequestBuilder request = this.client.prepareBulk();
            for (Span span : spans) {
                request.add(this.createSpanIndexRequest(span));
            }
            future = ElasticFutures.toGuava(request.execute());
        }
        if (ElasticsearchStorage.FLUSH_ON_WRITES) {
            future = Futures.transform(future, (AsyncFunction)new AsyncFunction(){

                public ListenableFuture apply(Object input) {
                    return ElasticFutures.toGuava(ElasticsearchSpanConsumer.this.client.admin().indices().prepareFlush(new String[]{ElasticsearchSpanConsumer.this.indexNameFormatter.catchAll()}).execute());
                }
            });
        }
        return Futures.transform(future, TO_VOID);
    }

    private IndexRequestBuilder createSpanIndexRequest(Span input) {
        byte[] spanBytes;
        long timestampMillis;
        Span span = ApplyTimestampAndDuration.apply((Span)input);
        if (span.timestamp != null) {
            timestampMillis = TimeUnit.MICROSECONDS.toMillis(span.timestamp);
            spanBytes = ElasticsearchSpanConsumer.prefixWithTimestampMillis(Codec.JSON.writeSpan(span), timestampMillis);
        } else {
            timestampMillis = System.currentTimeMillis();
            spanBytes = Codec.JSON.writeSpan(span);
        }
        String spanIndex = this.indexNameFormatter.indexNameForTimestamp(timestampMillis);
        return this.client.prepareIndex(spanIndex, "span").setSource(spanBytes);
    }

    @VisibleForTesting
    static byte[] prefixWithTimestampMillis(byte[] input, long timestampMillis) {
        String dateAsString = Long.toString(timestampMillis);
        byte[] newSpanBytes = new byte[TIMESTAMP_MILLIS_PREFIX.length + dateAsString.length() + input.length];
        int pos = 0;
        System.arraycopy(TIMESTAMP_MILLIS_PREFIX, 0, newSpanBytes, pos, TIMESTAMP_MILLIS_PREFIX.length);
        pos += TIMESTAMP_MILLIS_PREFIX.length;
        int length = dateAsString.length();
        for (int i = 0; i < length; ++i) {
            newSpanBytes[pos++] = (byte)dateAsString.charAt(i);
        }
        newSpanBytes[pos++] = 44;
        System.arraycopy(input, 1, newSpanBytes, pos, input.length - 1);
        return newSpanBytes;
    }
}

